% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_smap_credentials.R
\name{set_smap_credentials}
\alias{set_smap_credentials}
\title{Set credentials for NASA's Earthdata portal}
\usage{
set_smap_credentials(username, password, save = TRUE,
  overwrite = FALSE)
}
\arguments{
\item{username}{A character string of your Earthdata portal username}

\item{password}{A character string of your Earthdata portal password}

\item{save}{Logical: whether to save your credentials to your 
.Renviron file (e.g., ~/.Renviron). Previous Earthdata credentials will not 
be overwritten unless \code{overwrite = TRUE}.}

\item{overwrite}{Logical: whether to overwrite previous Earthdata credentials
in your .Renviron file (only applies when \code{save = TRUE})}
}
\value{
A data.frame with the names of the data files, the remote directory, and
  the date.
}
\description{
To use smapr, users need to provide NASA Earthdata portal credentials. 
This function allows users to interactively set these credentials via the 
user's Earthdata username and password.
}
\details{
If you do not yet have a username and password, register for one here:
https://urs.earthdata.nasa.gov/

A warning: do not commit your username and password to a public repository!
This function is meant to be used interactively, and not embedded within a 
script that you would share.
}
\examples{
\dontrun{
set_smap_credentials('myusername', 'mypassword')
}

}
