% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_smap.R
\name{extract_smap}
\alias{extract_smap}
\title{Extracts contents of SMAP data}
\usage{
extract_smap(data, name, in_memory = FALSE)
}
\arguments{
\item{data}{A data frame produced by \code{download_smap()} that specifies
input files from which to extract data.}

\item{name}{The path in the HDF5 file pointing to data to extract.}

\item{in_memory}{Logical. Should the result be stored in memory? If not, then
raster objects are stored on disk in the cache directory. By default
the result is stored on disk.}
}
\value{
Returns a RasterStack object.
}
\description{
Extracts datasets from SMAP data files.
}
\details{
The arguments \code{group} and \code{dataset} must refer specifically  the
group and name within group for the input file, such as can be obtained with
\code{list_smap()}. This function will extract that particular dataset,
returning a Raster object.
}
\examples{
\dontrun{
files <- find_smap(id = "SPL4SMGP", dates = "2015-03-31", version = 2)
downloads <- download_smap(files[1, ])
sm_raster <- extract_smap(downloads, name = '/Geophysical_Data/sm_surface')
}
}
