% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.scan.R
\name{plot.scan}
\alias{plot.scan}
\title{Plots object from spscan.test of class \code{scan}.}
\usage{
\method{plot}{scan}(x, ..., nv = 100, border = NULL, ccol = NULL,
  clty = NULL, clwd = NULL)
}
\arguments{
\item{x}{An object of class scan to be plotted.}

\item{...}{Additional graphical parameters passed to the \code{spatstat::plot.ppp} function.}

\item{nv}{The number of verticies to draw the circle. Default is 100.}

\item{border}{The border color of the circle.  Default is NULL, meaning black.}

\item{ccol}{Fill color of the circles.  Default is NULL, indicating empty.}

\item{clty}{Line type of circles.  Default is NULL, indicting lty = 1.}

\item{clwd}{Line width of circles.  Default is NULL, indicating lwd = 2 for the most likely cluster and lwd = 1 for the rest.}
}
\description{
Plots object from spscan.test of class \code{scan}.
}
\examples{
data(grave)
out = spscan.test(grave, case = 2, alpha = 0.1)
plot(out, chars = c(1, 20), main = "most likely cluster")
}
\seealso{
\code{\link[spatstat]{plot.ppp}}
}

