% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/noc.R
\name{noc}
\alias{noc}
\title{Determine non-overlapping clusters}
\usage{
noc(x)
}
\arguments{
\item{x}{A list containing the indexes of the potential clusters.}
}
\value{
A vector with the list indexes of the non-overlapping clusters.
}
\description{
Determine the indexes of the non-overlapping clusters
}
\details{
The functions takes a list of potential cluster indexes.  Each element of the list contains a potential cluster.  The potential clusters are defined by the location indexes of the regions comprising the clusters.  Starting with the first potential cluster, the function excludes every potential cluster that intersects the first (look at the location indexes comprising each cluster).  Moving onto the next non-overlapping cluster, the process is repeated.  The function returns the indexes (in the list of clusters) that do not overlap.
}
\examples{
x = list(1:2, 1:3, 4:5, 4:6, 7:8)
noc(x)
}
\author{
Joshua French
}

