% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_sbatch.R
\name{read_sbatch}
\alias{read_sbatch}
\title{Read a slurm batch file and capture the SBATCH options}
\usage{
read_sbatch(x)
}
\arguments{
\item{x}{Character scalar. Either the path to the batch file to process, or
a character vector.}
}
\value{
A named vector of the options starting with \verb{#SBATCH} in the file.
If no option is found, then returns a character vector length 0.
}
\description{
Read a slurm batch file and capture the SBATCH options
}
\examples{

# Reading in an example script
x <- system.file("example.slurm", package="slurmR")
read_sbatch(x)

}
