% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{logLik.slouch}
\alias{logLik.slouch}
\title{Extract Log-Likelihood}
\usage{
\method{logLik}{slouch}(object, ...)
}
\arguments{
\item{object}{An object of class 'slouch'}

\item{...}{Additional arguments.}
}
\value{
An object of class 'logLik'
}
\description{
Extract Log-Likelihood
}
\examples{
data(artiodactyla)
data(neocortex)

neocortex <- neocortex[match(artiodactyla$tip.label, neocortex$species), ]

m0 <- slouch.fit(phy = artiodactyla,
                 species = neocortex$species,
                 response = neocortex$body_mass_g_log_mean,
                 mv.response = neocortex$body_mass_g_log_varmean,
                 fixed.fact = neocortex$diet,
                 hillclimb = TRUE)
                 
logLik(m0)
}
