% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_slackr.r
\name{text_slackr}
\alias{text_slackr}
\title{text_slackr}
\usage{
text_slackr(
  text,
  ...,
  preformatted = TRUE,
  channel = Sys.getenv("SLACK_CHANNEL"),
  username = Sys.getenv("SLACK_USERNAME"),
  icon_emoji = Sys.getenv("SLACK_ICON_EMOJI"),
  bot_user_oauth_token = Sys.getenv("SLACK_BOT_USER_OAUTH_TOKEN")
)
}
\arguments{
\item{text}{The character vector to be posted}

\item{...}{Optional arguments such as: parse, unfurl_links, etc.}

\item{preformatted}{Should the text be sent as preformatted text. Defaults to TRUE}

\item{channel}{The name of the channels to which the DataTable should be sent.
Prepend channel names with a hashtag. Prepend private-groups with nothing.
Prepend direct messages with an @}

\item{username}{what user should the bot be named as (chr)}

\item{icon_emoji}{what emoji to use (chr) \code{""} will mean use the default}

\item{bot_user_oauth_token}{your full Slack bot user OAuth token}
}
\value{
\code{httr} response object (invisibly)
}
\description{
Sends basic text to a slack channel. Calls the chat.postMessage method on the Slack Web API.
Information on this method can be found here: \url{https://api.slack.com/methods/chat.postMessage}
}
\note{
You can pass in \code{as_user=TRUE} as part of the \code{...} parameters and the Slack API
will post the message as your logged-in user account (this will override anything set in
\code{username})
}
\examples{
\dontrun{
slackr_setup()
text_slackr("hello world", as_user = TRUE)
}
}
\references{
\url{https://github.com/mrkaye97/slackr/pull/11}
}
\seealso{
\url{https://api.slack.com/methods/chat.postMessage}
}
\author{
Quinn Weber (aut), Bob Rudis (ctb)
}
