% Generated by roxygen2 (4.0.1.99): do not edit by hand
\name{ggslackr}
\alias{ggslackr}
\title{Post a ggplot to a \url{slack.com} channel}
\usage{
ggslackr(plot = last_plot(), channels = Sys.getenv("SLACK_CHANNEL"),
  scale = 1, width = par("din")[1], height = par("din")[2],
  units = c("in", "cm", "mm"), dpi = 300, limitsize = TRUE,
  api_token = Sys.getenv("SLACK_API_TOKEN"), ...)
}
\arguments{
\item{plot}{ggplot object to save, defaults to last plot displayed}

\item{channels}{list of channels to post image to}

\item{scale}{scaling factor}

\item{width}{width (defaults to the width of current plotting window)}

\item{height}{height (defaults to the height of current plotting window)}

\item{units}{units for width and height when either one is explicitly specified (in, cm, or mm)}

\item{dpi}{dpi to use for raster graphics}

\item{limitsize}{when TRUE (the default), ggsave will not save images larger than 50x50 inches, to prevent the common error of specifying dimensions in pixels.}

\item{api_token}{the slack.com full API token (chr)}

\item{...}{other arguments passed to graphics device}
}
\value{
\code{httr} response object
}
\description{
Unlike the \code{\link{dev.slackr}} function, this one takes a \code{ggplot} object,
eliminating the need to have a graphics device (think use in scripts).
}
\note{
You need to setup a full API token (i.e. not a webhook & not OAuth) for this to work
}
\examples{
\dontrun{
slackrSetup()
ggslackr(qplot(mpg, wt, data=mtcars))
}
}

