% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotBars}
\alias{plotBars}
\title{Bar plot of orientations (declination)}
\usage{
plotBars(
  val,
  unc,
  names,
  unit = "Declination",
  col = "blue",
  shade = TRUE,
  mark = TRUE,
  sort = FALSE,
  xrange,
  yrange,
  obj,
  show.obj.label = TRUE
)
}
\arguments{
\item{val}{Array of declination or azimuth values.}

\item{unc}{Single value or array of measurement uncertainty}

\item{names}{(Optional) Array of names of measurements in \emph{val}}

\item{unit}{(Optional). Either 'Declination' or 'Azimuth'. Defaults to 'Declination'.}

\item{col}{(Optional) Color to plot measurements in. Defaults to \emph{blue}.}

\item{shade}{(Optional) Boolean to control whether to shade a polygon of measurements. Defaults
to \emph{TRUE}}

\item{mark}{(Optional) Boolean to control whether to mark the declination value. Defaults to
\emph{TRUE}}

\item{sort}{(Optional) Boolean to control whether to sort the measurements by their declination
value. Defaults to \emph{FALSE}}

\item{xrange}{(Optional) Array of limits for x-axis.}

\item{yrange}{(Optional) Array of limits for y-axis.}

\item{obj}{(Optional) A \emph{skyscapeR.object} object created with \code{\link{sky.objects}}
for displaying the declination values of celestial objects.}

\item{show.obj.label}{(Optional) Boolean to control whether to label the celestial objects in
the polar plot. Defaults to \emph{TRUE}.}
}
\description{
Bar plot of orientations (declination)
}
\examples{
# Plot some declination data:
decs <- c(10, 12, -5, 4)
plotBars(decs, unc=5)

# To visualize this data against the common solar and lunar targets:
tt <- sky.objects(c('solar extremes','lunar extremes'), epoch=-2000, lty=c(2,3))
plotBars(decs, unc=5, obj=tt)
}
\seealso{
\code{\link{sky.objects}}
}
