% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_num_fac.R
\name{is_num_fac}
\alias{is_num_fac}
\title{Check whether a factor has numeric levels only}
\usage{
is_num_fac(x)
}
\arguments{
\item{x}{A \code{\link{factor}}.}
}
\value{
Logical, \code{TRUE} if factor has numeric factor levels only,
          \code{FALSE} otherwise.
}
\description{
This function checks whether a factor has only numeric or
               any non-numeric factor levels.
}
\examples{
# numeric factor levels
f1 <- factor(c(NA, 1, 3, NA, 2, 4))
is_num_fac(f1)

# not completeley numeric factor levels
f2 <- factor(c(NA, "C", 1, 3, "A", NA, 2, 4))
is_num_fac(f2)

# not completeley numeric factor levels
f3 <- factor(c("Justus", "Bob", "Peter"))
is_num_fac(f3)

}
