% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write.R
\name{write_spss}
\alias{write_sas}
\alias{write_spss}
\alias{write_stata}
\title{Write data to other statistical software packages}
\usage{
write_spss(x, path, use.tagged.na = FALSE, enc.to.utf8 = FALSE)

write_stata(x, path, use.tagged.na = FALSE, enc.to.utf8 = FALSE,
  version = 14)

write_sas(x, path, use.tagged.na = FALSE, enc.to.utf8 = FALSE)
}
\arguments{
\item{x}{A data frame that should be saved as file.}

\item{path}{File path of the output file.}

\item{use.tagged.na}{Logical, if \code{TRUE}, \code{\link[haven]{tagged_na}}
values are converted to their values, i.e. values of tagged NA's are
converted to factor levels. If \code{FALSE} (default), tagged NA's
are converted to regular NA's.}

\item{enc.to.utf8}{Logical, if \code{TRUE}, character encoding of variable and
value labels will be converted to UTF-8.}

\item{version}{File version to use. Supports versions 8-14.}
}
\description{
These functions write the content of a data frame to an SPSS, SAS or
               Stata-file.
}
\note{
You don't need to take care whether variables have been imported with
        the \code{read_*} function from this package or from \pkg{haven}
        or even the \pkg{foreign} package, or if you have imported data and
        created new variables. These functions do all necessary data preparation
        to write a properly labelled data file.
}
\seealso{
\itemize{
           \item \href{http://www.strengejacke.de/sjPlot/datainit/}{sjPlot manual: data initialization}
           \item \href{http://www.strengejacke.de/sjPlot/view_spss/}{sjPlot manual: inspecting (SPSS imported) data frames}
           \item \code{\link{read_spss}}
           }
}

