% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/group_var.R
\name{group_var}
\alias{group_var}
\title{Recode count variables into grouped factors}
\usage{
group_var(var, groupsize = 5, as.num = TRUE, right.interval = FALSE,
  groupcount = 30, asNumeric, rightInterval, autoGroupCount)
}
\arguments{
\item{var}{Numeric; variable, which should recoded into groups.}

\item{groupsize}{Numeric; group-size, i.e. the range for grouping. By default,
for each 5 categories of \code{var} a new group is defined, i.e. \code{groupsize=5}.
Use \code{groupsize = "auto"} to automatically resize a variable into
a maximum of 30 groups (which is the ggplot-default grouping when
plotting histograms). Use \code{groupcount} to determine the amount
of groups.}

\item{as.num}{Logical; if \code{TRUE} (default), the recoded variable will
be returned as numeric vector. If \code{FALSE}, a factor is returned.}

\item{right.interval}{Logical; if \code{TRUE}, grouping starts with the lower
bound of \code{groupsize}. See 'Details'.}

\item{groupcount}{Sets the maximum number of groups that are defined when auto-grouping is on
(\code{groupsize="auto"}). Default is 30. If \code{groupsize} is not set to \code{"auto"},
this argument will be ignored.}

\item{asNumeric}{deprecated; use \code{as.num} instead}

\item{rightInterval}{deprecated; use \code{right.interval} instead}

\item{autoGroupCount}{deprecated; use \code{groupcount} instead}
}
\value{
A grouped variable, either as numeric or as factor (see paramter \code{as.num}).
}
\description{
Recode count variables into grouped factors, i.e. a variable is
               cut into a smaller number of groups.
}
\details{
If \code{groupsize} is set to a specific value, the variable is recoded
           into several groups, where each group has a maximum range of \code{groupsize}.
           Hence, the amount of groups differ depending on the range of \code{var}.
           \cr \cr
           If \code{groupsize = "auto"}, the variable is recoded into a maximum of
           \code{groupcount} groups. Hence, independent from the range of
           \code{var}, always the same amount of groups are created, so the range
           within each group differs (depending on \code{var}'s range).
           \cr \cr
           \code{right.interval} determins which boundary values to include when
           grouping is done. If \code{TRUE}, grouping starts with the \strong{lower
           bound} of \code{groupsize}. For example, having a variable ranging from
           50 to 80, groups cover the ranges from  50-54, 55-59, 60-64 etc.
           If \code{FALSE} (default), grouping starts with the \code{upper bound}
           of \code{groupsize}. In this case, groups cover the ranges from
           46-50, 51-55, 56-60, 61-65 etc. \strong{Note:} This will cover
           a range from 46-50 as first group, even if values from 46 to 49
           are not present. See 'Examples' in \code{\link{group_labels}}.
}
\note{
Variable label attributes (see, for instance, \code{\link{set_label}}) are preserved.
}
\examples{
age <- abs(round(rnorm(100, 65, 20)))
age.grp <- group_var(age, 10)
hist(age)
hist(age.grp)


# histogram with EUROFAMCARE sample dataset
# variable not grouped
data(efc)
hist(efc$e17age, main = get_label(efc$e17age))

# bar plot with EUROFAMCARE sample dataset
# grouped variable
ageGrp <- group_var(efc$e17age)
ageGrpLab <- group_labels(efc$e17age)
barplot(table(ageGrp),
        main = get_label(efc$e17age),
        names.arg = ageGrpLab)
}
\seealso{
\itemize{
           \item \code{\link{group_labels}}
           \item \code{\link{group_str}}
         }
}

