% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjRecode.R
\name{dicho}
\alias{dicho}
\title{Dichotomize variables}
\usage{
dicho(x, dichBy = "median", dichVal = -1, asNum = FALSE)
}
\arguments{
\item{x}{The variable (vector) or data frame that should be dichotomized.}

\item{dichBy}{Indicates the split criterion where the variable is dichotomized.
\itemize{
  \item By default, \code{var} is split into two groups at the median (\code{dichBy = "median"} or \code{dichBy = "md"}).
  \item \code{dichBy = "mean"} (or \code{dichBy = "m"}) splits \code{var} into two groups at the mean of \code{var}.
  \item \code{dichBy = "value"} (or \code{dichBy = "v"}) splits \code{var} into two groups at a specific value (see \code{dichVal}).
  }}

\item{dichVal}{numeric, indicates a value where \code{var} is dichotomized when \code{dichBy = "value"}.
\emph{Note that \code{dichVal} is inclusive}, i.e. \code{dichVal = 10} will split \code{var}
into one group with values from lowest to 10 and another group with values greater
than 10.}

\item{asNum}{logical, if \code{TRUE}, return value will be numeric, not a factor.}
}
\value{
A dichotomized factor (or numeric, if \code{asNum = TRUE}) variable (0/1-coded),
          respectively a data frame of dichotomized factor (or numeric) variables.
}
\description{
Dichotomizes variables into dummy variables (0/1). Dichotomization is
               either done by median, mean or a specific value (see \code{dichBy}).
               Either single vectors or complete data frames can be dichotomized.
}
\examples{
data(efc)
summary(efc$c12hour)
table(dicho(efc$c12hour))
table(dicho(efc$c12hour, "mean"))
table(dicho(efc$c12hour, "value", 30))

# sample data frame, values from 1-4
head(efc[, 6:10])
# dichtomized values (1 to 2 = 0, 3 to 4 = 1)
head(dicho(efc[, 6:10], "v", 2))
}

