% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjPlotSetTheme.R
\name{save_plot}
\alias{save_plot}
\title{Save ggplot-figure for print publication}
\usage{
save_plot(filename, fig = ggplot2::last_plot(), width = 12, height = 9,
  dpi = 300, theme = ggplot2::theme_get(), label.size = 2.4,
  axis.textsize = 0.8, axis.titlesize = 0.75, legend.textsize = 0.6,
  legend.titlesize = 0.65, legend.itemsize = 0.5)
}
\arguments{
\item{filename}{the name of the output file; filename must end with one
of the following acceptes file types: ".png", ".jpg", ".svg" or ".tif".}

\item{fig}{the plot that should be saved. By default, the last plot is saved.}

\item{width}{the width of the figure, in centimetres}

\item{height}{the height of the figure, in centimetres}

\item{dpi}{resolution in dpi (dots per inch). Ignored for vector formats, such as ".svg".}

\item{theme}{Name of a pre-set theme. May be one of:
\describe{
  \item{\code{"blank"}}{a theme with no grids and axes.}
  \item{\code{"forest"}}{a theme for forest plots, with no grids, in "539" style.}
  \item{\code{"538"}}{a grey-scaled theme inspired by \href{http://fivethirtyeight.com}{538-charts}, adapted from \href{http://minimaxir.com/2015/02/ggplot-tutorial/}{minimaxir.com}.}
  \item{\code{"539"}}{a slight modification of the 538-theme.}
  \item{\code{"scatter"}}{a theme for scatter plots in 539-theme-style.}
  \item{\code{"538w"}, \code{"539w"}, \code{"scatterw"} and \code{"forestw"}}{for themes as described above, however all with white backgrounds.}
}}

\item{label.size}{fontsize of value labels inside plot area}

\item{axis.textsize}{fontsize of axis labels}

\item{axis.titlesize}{fontsize of axis titles}

\item{legend.textsize}{fontsize of legend labels}

\item{legend.titlesize}{fontsize of legend title}

\item{legend.itemsize}{size of legend's item (legend key), in centimetres.}
}
\description{
Convenient function to save the last ggplot-figure in
               high quality for publication.
}
\note{
This is a convenient function with some default settings that should
        come close to most of the needs for fontsize and scaling in figures
        when saving them for printing or publishing. It uses cairographics
        anti-aliasing (see \code{\link[grDevices]{png}}).
}
