% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphMat-main.R
\docType{package}
\name{sizeMat-package}
\alias{sizeMat}
\alias{sizeMat-package}
\title{Size at Sexual Maturity.}
\description{
Contains functions to estimate morphometric and gonadal size at sexual maturity for organisms, usually fish and invertebrates. It includes methods for classification based on relative growth (principal components analysis, hierarchical clustering, discriminant analysis), logistic regression (frequentist or Bayes), parameters estimation and some basic plots. The size at sexual maturity is defined as the length at which a randomly chosen specimen has a 50% chance of being mature
}
\details{
Package: sizeMat

Type: Package

The Morphometric and Gonadal size at sexual maturity are estimating using differents functions (process).

1) The estimation of the Morphometric Size at Sexual Maturity involves two processes:

1.1) A Principal Components Analisys is conducted with two allometric variables (x: independent variable, y: dependent variable) in log base, allowing to distinguish 
two groups that would represent juveniles and adult. The individuals are assigned to each group using a hierarchical classification procedure (hierarchical cluster). 
This method is based on establishing a predetermined number of groups (in this case, two) and assigning individuals to one of the groups according to 
their loads on the two axes of the PCA (Corgos & Freire, 2006). Using the results of the classification (PCA + cluster), a discriminant analysis (linear or quadratic) 
is carried out to obtain a discriminating function that permitted any individuals to be classified as a juvenile or an adult on the basis of the X and Y 
allometric variables.

1.2) After classification, the logistic approach is used. The morphometric size at 50\% maturity (\eqn{L_50}) is estimated as the length at
which a randomly chosen specimen has a 50\% chance of being mature (Somerton  1980, Roa  et al. 1999, Corgos & Freire 2006). 
In the regression analysis, \eqn{X} (e.g: carapace width) is considered the explanatory variable and the classification \eqn{CS} 
(juvelines: 0, adults: 1) is considered the response variable (binomial). 

The variables are fitted to a logistic function with the form: 

\deqn{P_CS = 1 / [1+e^-(beta_0 + beta_1*X)]}

where:

\eqn{P_CL} is the probability of an individual of being mature at a determinate \eqn{X} length.
 
\eqn{beta_0} (intercept) and \eqn{beta_1} (slope) are parameters estimated. 

The (\eqn{L_50}) is calculated as: 

\deqn{L_50 = -beta_0 / beta_1}

Some basic plotting (classification, \eqn{beta_0}, \eqn{beta_1} and \eqn{L_50} histogram, and maturity ogive) 
are also provided.


2) The estimation of Gonadal Size at Sexual Maturity use the logistic approach only. 

To estimate gonadal size at sexual maturity, the database must contains the stage of sexual 
maturity and at least one allometric variable (e.g: total length, fork length, carapace width).
The stage of sexual maturity is refered to the gonadal maturarion stages (e.g: I, II, III, IV or 0, 1, etc).

So, in the regression analysis, the allometric variable (e.g: total length) is considered the
explanatory variable and the stage of sexual maturity (inmature: 0, mature: 1) 
is considered the response variable (binomial). The regression  analysis is performed 
in the same way as the morphometric size at sexual maturity.
}
\examples{
#See examples for functions morph_mature() and gonad_mature().
}
\author{
Josymar Torrejon-Magallanes <ejosymart@gmail.com>
}
\references{
Agostinho, C. S. (2000). Use of otoliths to estimate size at sexual maturity in fish. Brazilian Archives of Biology and Technology, 43(4).

Corgos, A. & Freire, J. (2006). Morphometric and gonad maturity in the spider crab Maja brachydactyla: a comparison of methods for estimating size at maturity in species with determinate growth. ICES Journal of Marine Science: Journal du Conseil, 63(5), 851-859.

Roa, R., Ernst, B. & Tapia, F. (1999). Estimation of size at sexual maturity: an evaluation of analytical and resampling procedures. Fishery Bulletin, 97(3), 570-580.

Somerton, D. A. (1980). A computer technique for estimating the size of sexual maturity in crabs. Canadian Journal of Fisheries and Aquatic Sciences, 37(10), 1488-1494.
}
\keyword{alometric,}
\keyword{morphometric,}
\keyword{relative-growth.}
\keyword{sexual-maturity,}
\keyword{size,}

