% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gonadMat-main.R
\name{plot.gonadMat}
\alias{plot.gonadMat}
\title{Plot method for gonadMat class (gonadal size at sexual maturity)}
\usage{
\method{plot}{gonadMat}(x, xlab = "X", ylab = "Proportion mature",
  col = c("blue", "red"), lwd = 2, lty = 2, vline_hist = "black",
  lwd_hist = 2, lty_hist = 2, ...)
}
\arguments{
\item{x}{object of class 'gonadMat' with the mature parameters and a data.frame with the X and stage of sexual maturity.
variables. Also the fitted values for the logistic regression and confidence intervals (95\%).}

\item{xlab}{a title for the x axis.}

\item{ylab}{a title for the y axis.}

\item{col}{color for the logistic curve and for the L50\% morphometric size at sexual maturity.}

\item{lwd}{line with for drawing fitted values and confidence intervals.}

\item{lty}{line type line type for drawing fitted values and confidence intervals}

\item{vline_hist}{color of the vertival lines in the histogram. The lines represent the 
the median and the confidece intervals.}

\item{lwd_hist}{line with for the vertical line in the histogram.}

\item{lty_hist}{line type for the vertical line in the histogram.}

\item{\dots}{Additional arguments to the plot method.}
}
\description{
Plot method for gonadMat class (gonadal size at sexual maturity)
}
\examples{
data(matFish)

gonad_mat = gonad_mature(matFish, varNames = c("total_length", "stage_mat"), inmName = "I", 
matName = c("II", "III", "IV"), method = "fq", niter = 50)

plot(gonad_mat, xlab = "Total length (cm.)", ylab = "Proportion mature", col = c("blue", "red"))
}

