% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_combine_predictions.R
\name{sits_combine_predictions}
\alias{sits_combine_predictions}
\alias{sits_combine_predictions.average}
\alias{sits_combine_predictions.uncertainty}
\title{Estimate ensemble prediction based on list of probs cubes}
\usage{
sits_combine_predictions(
  cubes,
  type = "average",
  ...,
  multicores = 2,
  memsize = 8,
  output_dir = ".",
  version = "v1"
)

\method{sits_combine_predictions}{average}(
  cubes,
  type = "average",
  ...,
  multicores = 2,
  memsize = 4,
  output_dir = getwd(),
  version = "v1"
)

\method{sits_combine_predictions}{uncertainty}(
  cubes,
  type = "uncertainty",
  ...,
  uncert_cubes,
  multicores = 2,
  memsize = 4,
  output_dir = getwd(),
  version = "v1"
)
}
\arguments{
\item{cubes}{List of probability data cubes.}

\item{type}{Method to measure uncertainty. See details.}

\item{...}{Parameters for specific functions.}

\item{multicores}{Number of cores to run the function.}

\item{memsize}{Maximum overall memory (in GB) to run the
function.}

\item{output_dir}{Output directory for image files.}

\item{version}{Version of resulting image.
(in the case of multiple tests)}

\item{uncert_cubes}{Uncertainty cubes to be used as local weights.}
}
\value{
A combined probability cube
}
\description{
Calculate an ensemble predictor based a list of probability
cubes. The function combines the output of two or more classifier
to derive a value which is based on weights assigned to each model.
The supported types of ensemble predictors are 'average' and
'uncertainty'.
}
\note{
Please refer to the sits documentation available in
<https://e-sensing.github.io/sitsbook/> for detailed examples.
}
\examples{
if (sits_run_examples()) {
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6",
        data_dir = data_dir,
        delim = "_",
        parse_info = c("X1", "tile", "band", "date")
    )
    # create a random forest model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # classify a data cube using rfor model
    probs_rfor_cube <- sits_classify(data = cube, ml_model = rfor_model)
    # create an XGBoost model
    xgb_model <- sits_train(samples_modis_ndvi, sits_xgboost())
    # classify a data cube using xgboost model
    probs_xgb_cube <- sits_classify(data = cube, ml_model = xgb_model)
    # create a list of predictions to be combined
    pred_cubes <- list(probs_rfor_cube, probs_xgb_cube)
    # combine predictions
    comb_probs_cube <- sits_combine_predictions(cubes = pred_cubes)
    # plot the resulting combined prediction cube
    plot(comb_probs_cube)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}

Rolf Simoes, \email{rolf.simoes@inpe.br}
}
