% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apv_se.R
\name{apv_se}
\alias{apv_se}
\title{Bootstrap standard errors for SITAR peak velocity and age at peak velocity}
\usage{
apv_se(object, nboot = 10, seed = NULL, plot = FALSE, ...)
}
\arguments{
\item{object}{SITAR model.}

\item{nboot}{number of bootstrap samples (default 10).}

\item{seed}{integer to initialize the random number generator (default NULL).}

\item{plot}{logical to control plotting (default FALSE).}

\item{\dots}{optional arguments defining the velocity
curve to be bootstrapped, and the plot. See Details.}
}
\value{
a 2x2 array giving the mean and se of apv and pv, with attribute "bs"
a tibble containing the bootstrap estimates of apv and pv, with NAs removed.
}
\description{
\code{apv_se} bootstraps a SITAR model to generate standard errors for
age at peak velocity (apv) and peak velocity (pv).
}
\details{
The mean velocity curve to be bootstrapped can be modified with
arguments \code{subset}, \code{abc}, \code{xfun}, \code{yfun} or \code{ns}.

If \code{plot} is TRUE, the original velocity curve is plotted along with
each bootstrap sample's pv versus apv.
}
\examples{
data(heights)
## fit sitar model for height
model <- sitar(x = age, y = height, id = id, data = heights, df = 4)

## bootstrap standard errors for age at peak velocity and peak velocity
output <- apv_se(model, nboot=3, seed=111, plot=TRUE)
}
\author{
Tim Cole \email{tim.cole@ucl.ac.uk}
}
