% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.singleRStaticCountData}
\alias{plot.singleRStaticCountData}
\title{Diagnostic plots for regression and population size estimation.}
\usage{
\method{plot}{singleRStaticCountData}(
  x,
  plotType = c("qq", "marginal", "fitresid", "bootHist", "rootogram", "dfpopContr",
    "dfpopBox", "scaleLoc", "cooks", "hatplot", "strata"),
  confIntStrata = c("normal", "logNormal"),
  histKernels = TRUE,
  dfpop,
  ...
)
}
\arguments{
\item{x}{object of \code{singleRStaticCountData} class.}

\item{plotType}{character parameter specifying type of plot to be made.
The following list presents and briefly explains possible type of plots:
\itemize{
\item \code{qq} -- The quantile-quantile plot for pearson residuals
(or standardized pearson residuals if these are available for the model) i.e.
empirical quantiles from residuals are plotted against theoretical quantiles
from standard distribution.
\item \code{marginal} -- A plot made by \code{matplot} with fitted and
observed marginal frequencies with labels.
\item \code{fitresid} -- Plot of fitted linear predictors against
(standardized) pearson residuals.
\item \code{bootHist} -- Simple histogram for statistics obtained from
bootstrapping (if one was performed and the statistics were saved).
\item \code{rootogram} -- Rootogram, for full explanation see:
Kleiber and Zeileis Visualizing Count Data Regressions Using Rootograms (2016),
in short it is a \code{barplot} where height is the square root of observed marginal
frequencies adjusted by difference between square root of observed and fitted marginal
frequencies connected by line representing fitted marginal frequencies.
The less of a difference there is between the 0 line and beginning of a bar
the more accurate fitt was produced by the model.
\item \code{dfpopContr} -- Plot of \code{dfpopsize} against unit contribution.
On the plot is y = x line i.e. what deletion effect would be if removing the
unit from the model didn't effect regression coefficients. The further away
the observation is from this line the more influential it is.
\item \code{dfpopBox} -- Boxplot of \code{dfpopsize} for getting the general
idea about the distribution of the "influence" of each unit on
population size estimate.
\item \code{scaleLoc} -- The scale - location plot i.e. square root of
absolute values of (standardized) pearson residuals against linear predictors
for each column of linear predictors.
\item \code{cooks} -- Plot of cooks distance for detecting influential observations.
\item \code{hatplot} -- Plot of hat values for each linear predictor for detecting influential observations.
\item \code{strata} -- Plot of confidence intervals and point estimates for strata provided in \code{...} argument
}}

\item{confIntStrata}{confidence interval type to use for strata plot.
Currently supported values are \code{"normal"} and \code{"logNormal"}.}

\item{histKernels}{logical value indicating whether to add density lines
to histogram.}

\item{dfpop}{TODO}

\item{...}{additional optional arguments passed to the following functions:
\itemize{
\item For \code{plotType = "bootHist"}
\itemize{
\item \code{graphics::hist} -- with \code{x, main, xlab, ylab} parameters fixed.
}
\item For \code{plotType = "rootogram"}
\itemize{
\item \code{graphics::barplot} -- with \code{height, offset, ylab, xlab, ylim} parameters fixed.
\item \code{graphics::lines} -- with \code{x, y, pch, type, lwd, col} parameters fixed.
}
\item For \code{plotType = "dfpopContr"}
\itemize{
\item \code{dfpopsize} -- with \code{model, observedPop} parameters fixed.
\item \code{plot.default} -- with \code{x, y, xlab, main} parameters fixed.
}
\item For \code{plotType = "dfpopBox"}
\itemize{
\item \code{dfpopsize} -- with \code{model, observedPop} parameters fixed.
\item \code{graphics::boxplot} -- with \code{x, ylab, main} parameters fixed.
}
\item For \code{plotType = "scaleLoc"}
\itemize{
\item \code{plot.default} -- with \code{x, y, xlab, ylab, main, sub} parameters fixed.
}
\item For \code{plotType = "fitresid"}
\itemize{
\item \code{plot.default} -- with \code{x, y, xlab, ylab, main, sub} parameters fixed.
}
\item For \code{plotType = "cooks"}
\itemize{
\item \code{plot.default} -- with \code{x, xlab, ylab, main} parameters fixed.
}
\item For \code{plotType = "hatplot"}
\itemize{
\item \code{hatvalues.singleRStaticCountData}
\item \code{plot.default} -- with \code{x, xlab, ylab, main} parameters fixed.
}
\item For \code{plotType = "strata"}
\itemize{
\item \code{stratifyPopsize.singleRStaticCountData}
}
}}
}
\value{
No return value only the plot being made.
}
\description{
Simple diagnostic plots for \code{singleRStaticCountData} class objects.
}
\seealso{
\code{\link[=estimatePopsize]{estimatePopsize()}} \code{\link[=dfpopsize]{dfpopsize()}} \code{\link[=marginalFreq]{marginalFreq()}} \code{\link[stats:plot.lm]{stats::plot.lm()}} \code{\link[stats:influence.measures]{stats::cooks.distance()}} \code{\link[=hatvalues.singleRStaticCountData]{hatvalues.singleRStaticCountData()}}
}
\author{
Piotr Chlebicki
}
