% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dissoc_power.R
\name{BSDT_power}
\alias{BSDT_power}
\title{Power calculator for BSDT}
\usage{
BSDT_power(
  case_a,
  case_b,
  mean_a = 0,
  mean_b = 0,
  sd_a = 1,
  sd_b = 1,
  r_ab = 0.5,
  sample_size,
  alternative = c("two.sided", "greater", "less"),
  alpha = 0.05,
  nsim = 1000,
  iter = 1000,
  calibrated = TRUE
)
}
\arguments{
\item{case_a}{A single value from the expected case observation on task A.}

\item{case_b}{A single value from the expected case observation on task B.}

\item{mean_a}{The expected mean from the control sample on task A. Defaults
to 0.}

\item{mean_b}{The expected mean from the control sample on task B. Defaults
to 0.}

\item{sd_a}{The expected standard deviation from the control sample on task
A. Defaults to 1.}

\item{sd_b}{The expected standard deviation from the control sample on task
B. Defaults to 1.}

\item{r_ab}{The expected correlation between the tasks. Defaults to 0.5}

\item{sample_size}{The size of the control sample, vary this parameter to see
how the sample size affects power.}

\item{alternative}{The alternative hypothesis. A string of either "two.sided"
(default) or "one.sided".}

\item{alpha}{The specified Type I error rate. This can be varied, with
effects on power. Defaults to 0.05.}

\item{nsim}{The number of simulations to run. Higher number gives better
accuracy, but low numbers such as 10000 or even 1000 are usually sufficient
for the purposes of this calculator. Defaults to 1000 due to the
computationally intense \code{BSTD}.}

\item{iter}{The number simulations used by \code{BSTD}. Defaults to 1000.}

\item{calibrated}{Whether or not to use the standard theory (Jeffreys) prior
distribution (if set to \code{FALSE}) or a calibrated prior. See Crawford
et al. (2011) for further information. Calibrated prior is recommended.}
}
\value{
Returns a single value approximating the power of the test for the
  given parameters.
}
\description{
Calculates approximate power, given sample size, using Monte Carlo
simulation, for specified case scores, means and standard deviations for the
control sample. The means and standard deviations default to 0 and 1
respectively, so if no other values are given the case scores are interpreted
as deviations from the mean in standard deviations. Hence, the effect size of
the dissociation (Z-DCC) would in that case be the difference between the two
case scores. Is computationally heavy and might therefore take a few seconds.
}
\examples{
BSDT_power(case_a = -3, case_b = -1, mean_a = 0, mean_b = 0,
           sd_a = 1, sd_b = 1, r_ab = 0.5, sample_size = 20, nsim = 100, iter = 100)
}
