% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simul.R
\name{simul}
\alias{simul}
\title{Find Simultaneous Confidence Band Critical Value}
\usage{
simul(x, eif, nobs, reps = 1e+05, level = 0.95)
}
\arguments{
\item{x}{A list of parameter estimates.}

\item{eif}{A list of empirical efficient influence functions corresponding to the estimates in \code{x}.}

\item{nobs}{The number of observations.}

\item{reps}{The number of repetitions to use for the multiplier bootstrap, the default is 1e5.}

\item{level}{The confidence level for the critical value should be calculated for, the default is 0.95.}
}
\value{
The estimated critical value satisfying the requirements for a uniform confidence band around all estimates.
}
\description{
Find Simultaneous Confidence Band Critical Value
}
\examples{
data(eif)
psi <- lapply(eif, function(x) mean(x))
n <- length(eif[[1]])
simul(psi, eif, n)
}
