% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ACF.R
\name{theo_pacf}
\alias{theo_pacf}
\title{Theoretical Partial Autocorrelation (PACF) of an ARMA process}
\usage{
theo_pacf(ar, ma = NULL, lagmax = 20)
}
\arguments{
\item{ar}{A \code{vector} containing the AR coefficients.}

\item{ma}{A \code{vector} containing the MA coefficients.}

\item{lagmax}{An \code{integer} indicating the maximum lag up to which to compute the theoretical PACF.}
}
\description{
This function computes the theoretical Partial Autocorrelation (PACF) of an ARMA process.
}
\examples{
# Computes the theoretical ACF for an ARMA(1,0) (i.e. a first-order autoregressive model: AR(1))
theo_pacf(ar = -0.25, ma = NULL, lagmax = 7)
# Computes the theoretical ACF for an ARMA(2, 1)
theo_pacf(ar = c(.50, -0.25), ma = .20, lagmax = 10)
}
\author{
Yuming Zhang
}
