% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{make_frame}
\alias{make_frame}
\title{Default utility function for various plots titles}
\usage{
make_frame(
  x_range,
  y_range,
  xlab,
  ylab,
  main = "",
  mar = c(5.1, 5.1, 1, 2.1),
  add_axis_x = TRUE,
  add_axis_y = TRUE,
  col_box = "black",
  col_grid = "grey95",
  col_band = "grey95",
  col_title = "black",
  add_band = TRUE,
  title_band_width = 0.09,
  grid_lty = 1
)
}
\arguments{
\item{x_range}{A \code{numeric} providing the range of values for the x-axis.}

\item{y_range}{A \code{numeric} providing the range of values for the y-axis.}

\item{xlab}{A \code{string} that gives a title for the x-axis.}

\item{ylab}{A \code{string} that gives a title for the y-axis.}

\item{main}{A \code{string} that gives an overall title for the plot. Default is an empty string.}

\item{mar}{A \code{vector} indicating overall margin values for the plot.}

\item{add_axis_x}{A \code{boolean} indicating whether a x-axis should be added.}

\item{add_axis_y}{A \code{boolean} indicating whether a y-axis should be added.}

\item{col_box}{A \code{string} indicating the color for the title box.}

\item{col_grid}{A \code{string} indicating the color of the grid for the plot.}

\item{col_band}{A \code{string} indicating the color of the band.}

\item{col_title}{A \code{string} indicating the color of the plot title.}

\item{add_band}{A \code{boolean} indicating whether there should be a band.}

\item{title_band_width}{A \code{double} providing the value of the band width. Default is 0.09.}

\item{grid_lty}{A \code{integer} indicating the line type of the grid lines.}
}
\value{
Added title, grid, and axes.
}
\description{
Adds title, grid, and required x- and y-axes.
}
\examples{
make_frame(x_range = c(0, 1), y_range = c(0, 1), xlab = "my xlab", 
           ylab = "my ylab", main = "my title")
           
make_frame(x_range = c(0, 1), y_range = c(0, 1), xlab = "my xlab", 
           ylab = "my ylab", add_band = FALSE)
           
make_frame(x_range = c(0, 1), y_range = c(0, 1), xlab = "my xlab", 
           ylab = "my ylab", main = "my title", col_band = "blue3", 
           col_title = "white", col_grid = "lightblue", grid_lty = 3)

make_frame(x_range = c(0, 1), y_range = c(0, 1), xlab = "my xlab", 
           ylab = "my ylab", main = "my title", col_band = "blue3", 
           col_title = "white", col_grid = "lightblue", grid_lty = 3,
           title_band_width = 0.18)
}
\author{
Stephane Guerrier and Justin Lee
}
