% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addColumns.R
\name{addColumns}
\alias{addColumns}
\title{Add columns to existing data set}
\usage{
addColumns(dtDefs, dtOld)
}
\arguments{
\item{dtDefs}{Name of definitions for added columns}

\item{dtOld}{Name of data table that is to be updated}
}
\value{
An updated data.table that contains the added simulated data
}
\description{
Add columns to existing data set
}
\examples{
# New data set

def <- defData(varname = "xNr", dist = "nonrandom", formula=7, id = "idnum")
def <- defData(def, varname="xUni", dist="uniform", formula="10;20")

dt <- genData(10, def)

# Add columns to dt

def2 <- defDataAdd(varname="y1", formula = 10, variance = 3)
def2 <- defDataAdd(def2, varname="y2", formula = .5, dist = "binary")
def2

dt <- addColumns(def2, dt)
dt
}
