% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_sf.R
\name{gg_sf}
\alias{gg_sf}
\title{Simple feature ggplot map.}
\usage{
gg_sf(
  data,
  text_var = NULL,
  borders = NULL,
  borders_on_top = NULL,
  pal = pal_viridis_mix(1),
  pal_borders = "#7F7F7F",
  alpha_fill = NULL,
  alpha_line = 1,
  alpha_point = 1,
  alpha_borders = 0.5,
  size_line = 0.5,
  size_point = 1.5,
  size_borders = 0.2,
  title = NULL,
  title_wrap = 80,
  subtitle = NULL,
  subtitle_wrap = 80,
  caption = NULL,
  caption_wrap = 80,
  theme = gg_theme(void = TRUE),
  mobile = FALSE
)
}
\arguments{
\item{data}{A sf object with defined coordinate reference system in a structure to be plotted untransformed. Required input.}

\item{text_var}{Unquoted variable to be used as a customised tooltip in combination with plotly::ggplotly(plot, tooltip = "text"). Defaults to NULL.}

\item{borders}{A sf object as administrative boundaries (or coastlines). Defaults to no boundaries added. The rnaturalearth package is a useful source of country and state boundaries.}

\item{borders_on_top}{TRUE or FALSE  as to whether the borders are on top of the sf object supplied to the data argument. Defaults to TRUE for points and lines, but FALSE for polygons..}

\item{pal}{Character vector of hex codes.}

\item{pal_borders}{Colour of the borders. Defaults to "#7F7F7F".}

\item{alpha_fill}{The opacity of the fill.}

\item{alpha_line}{The alpha of lines and outlines.}

\item{alpha_point}{The alpha of points.}

\item{alpha_borders}{Opacity of the borders. Defaults to 0.5.}

\item{size_line}{Size of lines. Defaults to 0.5.}

\item{size_point}{Size of points. Defaults to 1.5.}

\item{size_borders}{Size of the borders. Defaults to 0.2.}

\item{title}{Title string.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 75.}

\item{subtitle}{Subtitle string.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 100. Not applicable where mobile equals TRUE.}

\item{caption}{Caption title string.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 80.}

\item{theme}{A ggplot2 theme.}

\item{mobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE.}
}
\value{
A ggplot object.
}
\description{
Map of simple features in ggplot that is not coloured and not facetted.
}
\examples{
gg_sf(example_point, 
     borders = example_borders)
     
}
