% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaflet_sf.R
\name{leaflet_sf}
\alias{leaflet_sf}
\title{Simple feature leaflet map.}
\usage{
leaflet_sf(
  data,
  popup_vars_vctr = NULL,
  pal = NULL,
  size_point = 2,
  size_line = 2,
  alpha = 0.9,
  basemap = "light",
  title = NULL,
  map_id = "map"
)
}
\arguments{
\item{data}{An sf object of geometry type point/multipoint, linestring/multilinestring or polygon/multipolygon geometry type. Required input.}

\item{popup_vars_vctr}{Vector of quoted variable names to include in the popup. If NULL, defaults to making a leafpop::popupTable of all columns.}

\item{pal}{Character vector of hex codes.}

\item{size_point}{Size of points (i.e. radius). Defaults to 2.}

\item{size_line}{Size of lines around features (i.e. weight). Defaults to 2.}

\item{alpha}{The opacity of the fill within features (i.e. fillOpacity). Defaults to 0.9.}

\item{basemap}{The underlying basemap. Either "light", "dark", "satellite", "street", or "ocean". Defaults to "light". Only applicable where shiny equals FALSE.}

\item{title}{A title string that will be wrapped into the legend.}

\item{map_id}{The shiny map id for a leaflet map within a shiny app. For standard single-map apps, id "map" should be used. For dual-map apps, "map1" and "map2" should be used. Defaults to "map".}
}
\value{
A leaflet object.
}
\description{
Map of simple features in leaflet that is not coloured.
}
\examples{
leaflet_sf(example_sf_point)

leaflet_sf(example_sf_polygon)

}
