% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaflet_sf_fun.R
\name{leaflet_sf_col}
\alias{leaflet_sf_col}
\title{Map of simple features in leaflet that is coloured.}
\usage{
leaflet_sf_col(data, col_var, label_var = NULL, col_method = NULL,
  col_cuts = NULL, col_drop = FALSE, col_na_remove = FALSE,
  pal = NULL, pal_rev = FALSE, popup = NULL, radius = 1,
  weight = 2, opacity = 0.9, stroke = TRUE, title = "[Title]",
  legend_digits = 1, legend_labels = NULL, basemap = "light",
  map_id = "map")
}
\arguments{
\item{data}{An sf object of geometry type point/multipoint, linestring/multilinestring or polygon/multipolygon geometry type. Required input.}

\item{col_var}{Unquoted variable to colour the features by. Required input.}

\item{label_var}{Unquoted variable to label the features by. If NULL, defaults to using the colour variable.}

\item{col_method}{The method of colouring features, either "bin", "quantile" or "category." if categorical colour variable, NULL results in "category". If numeric variable, defaults to "quantile". Note all numeric variables are cut to be inclusive of the min in the range, and exclusive of the max in the range (except for the final bucket which includes the highest value).}

\item{col_cuts}{A vector of cuts to colour a numeric variable. If "bin" is selected, the first number in the vector should be either -Inf or 0, and the final number Inf. If "quantile" is selected, the first number in the vector should be 0 and the final number should be 1. Defaults to quartiles.}

\item{col_drop}{TRUE or FALSE of whether to drop unused levels from the legend. Defaults to FALSE.}

\item{col_na_remove}{TRUE or FALSE  of whether to remove NAs of the colour variable. Defaults to FALSE.}

\item{pal}{Character vector of hex codes. Defaults to NULL, which selects the colorbrewer Set1 or viridis.}

\item{pal_rev}{Reverses the palette. Defaults to FALSE.}

\item{popup}{HTML strings for use in popup through a character vector. If NULL, defaults to making a leafpop::popupTable of all columns in the sf object.}

\item{radius}{Radius of points. Defaults to 2.}

\item{weight}{Stroke border size. Defaults to 2.}

\item{opacity}{The opacity of polygons. Defaults to 0.9.}

\item{stroke}{TRUE or FALSE of whether to draw a border around the features. Defaults to TRUE.}

\item{title}{A title string that will be wrapped into the legend. Defaults to "Title".}

\item{legend_digits}{Select the appropriate number of decimal places for numeric variable auto legend labels. Defaults to 1.}

\item{legend_labels}{A vector of manual legend label values. Defaults to NULL, which results in automatic labels.}

\item{basemap}{The underlying basemap. Either "light", "dark", "satellite", "street", or "ocean". Defaults to "light". Only applicable where shiny equals FALSE.}

\item{map_id}{The shiny map id for a leaflet map within a shiny app. For standard single-map apps, id "map" should be used. For dual-map apps, "map1" and "map2" should be used. Defaults to "map".}
}
\value{
A leaflet object.
}
\description{
Map of simple features in leaflet that is coloured.
}
\examples{
leaflet_sf_col(example_sf_polygon, density,
     col_method = "quantile", col_cuts = c(0, 0.25, 0.5, 0.75, 0.95, 1),
     title = "Modelled density, 2017")

leaflet_sf_col(example_sf_polygon, density,
     col_method = "bin", col_cuts = c(0, 10, 50, 100, 150, 200, Inf), legend_digits = 0,
     title = "Modelled density, 2017")

pal <- c("#4575B4", "#D3D3D3", "#D73027")

leaflet_sf_col(example_sf_point, trend_category, pal = pal, col_method = "category",
   title = "Monitored river nitrate-nitrogen trends, 2008\\u201317")
}
