% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_stars_fun.R
\name{ggplot_stars_col_facet}
\alias{ggplot_stars_col_facet}
\title{Map of an array in ggplot that is coloured and facetted.}
\usage{
ggplot_stars_col_facet(data, col_method = "quantile",
  quantile_cuts = c(0, 0.05, 0.25, 0.5, 0.75, 0.95, 1),
  quantile_by_facet = TRUE, bin_cuts = NULL, pal = NULL,
  rev_pal = FALSE, coastline = NULL, coastline_behind = TRUE,
  coastline_pal = "#7f7f7f", facet_nrow = NULL, legend_ncol = 3,
  legend_digits = 1, title = "[Title]", subtitle = NULL,
  col_title = "", caption = "", legend_labels = NULL,
  font_family = "Helvetica", font_size_title = 11,
  font_size_body = 10, wrap_title = 70, wrap_subtitle = 80,
  wrap_col_title = 25, wrap_caption = 80, isMobile = FALSE)
}
\arguments{
\item{data}{A stars object with 2 dimensions, x and y, and multiple named attribute layers with usual convention of lower case and underscores. Required input.}

\item{col_method}{The method of colouring features, either "bin", "quantile" or "category." Defaults to "quantile". Note all numeric variables are cut to be inclusive of the min in the range, and exclusive of the max in the range (except for the final bucket which includes the highest value).}

\item{quantile_cuts}{A vector of probability cuts applicable where col_method of "quantile" is selected. The first number in the vector should 0 and the final number 1. Defaults to 0-0.05, 0.05-0.25, 0.25-0.5, 0.5-0.75, 0.75-0.95, and 0.95-1. Only applicable where col_method equals "quantile".}

\item{quantile_by_facet}{TRUE of FALSE whether quantiles should be calculated for each group of the facet variable. Defaults to TRUE.}

\item{bin_cuts}{A vector of bin cuts applicable where col_method of "bin" is selected. The first number in the vector should be either -Inf or 0, and the final number Inf. If NULL, 'pretty' breaks are used.  Only applicable where col_method equals "bin".}

\item{pal}{Character vector of hex codes, or provided objects with pal_ prefixes. Defaults to viridis.}

\item{rev_pal}{Reverses the palette. Defaults to FALSE.}

\item{coastline}{Add a sf object as a coastline (or administrative boundaries). Defaults to NULL. Use nz (or nz_region) to add a new zealand coastline. Or add a custom sf object.}

\item{coastline_behind}{TRUE or FALSE as to whether the coastline is to be behind the stars object defined in the data argument. Defaults to FALSE.}

\item{coastline_pal}{Colour of the coastline. Defaults to "#7F7F7F".}

\item{facet_nrow}{The number of rows of facetted plots. Not applicable to where isMobile is TRUE.}

\item{legend_ncol}{The number of columns in the legend.}

\item{legend_digits}{Select the appropriate number of decimal places for numeric variable auto legend labels. Defaults to 1.}

\item{title}{Title string. Defaults to "[Title]".}

\item{subtitle}{Subtitle string. Defaults to "[Subtitle]".}

\item{col_title}{Colour title string for the legend. Defaults to NULL.}

\item{caption}{Caption title string. Defaults to NULL.}

\item{legend_labels}{A vector of manual legend label values. Defaults to NULL, which results in automatic labels.}

\item{font_family}{Font family to use. Defaults to "Helvetica".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}

\item{wrap_title}{Number of characters to wrap the title to. Defaults to 70. Not applicable where isMobile equals TRUE.}

\item{wrap_subtitle}{Number of characters to wrap the subtitle to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{wrap_col_title}{Number of characters to wrap the colour title to. Defaults to 25. Not applicable where isMobile equals TRUE.}

\item{wrap_caption}{Number of characters to wrap the caption to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{isMobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE. In a shinyapp, isMobile should be specified as input$isMobile. TRUEhis enable mobile compatible apps, where apps have ui mobileDetect function defined and mobile.js file in www/js/ folder  https://g3rv4.com/2017/08/shiny-detect-mobile-browsers}
}
\value{
A ggplot object.
}
\description{
Map of an array in ggplot that is coloured and facetted.
}
\examples{
map_data1 <- example_stars_nz_no3n \%>\%
  rlang::set_names("nitrate_nitrogen")

map_data2 <- example_stars_nz_drp \%>\%
  rlang::set_names("dissolved_reactive_phosphorus")

map_data <- c(map_data1, map_data2)

ggplot_stars_col_facet(data = map_data, coastline = nz,
     title = "River modelled nutrient concentrations, 2013\\u201317")
}
