% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimplaceWrapper.R
\name{varmapToList}
\alias{varmapToList}
\title{Converts the varmap to a list}
\usage{
varmapToList(varmap, expand = TRUE)
}
\arguments{
\item{varmap}{the varMap returned by \code{\link{stepSimulation}}}

\item{expand}{if \code{TRUE} expand array objects to vector.}
}
\value{
list with parameter name as key and parameter value as value
}
\description{
Converts the varMap to a list. All elements are converted to appropriate
R objects. Arrays are expanded to vectors by default.
}
\examples{
\dontrun{
simplace <- initSimplace(SimplaceInstallationDir,SimplaceWorkDir,SimplaceOutputDir)
openProject(simplace, Solution)
createSimulation(simplace)
varmap <- stepSimulation(simplace,count=22)
closeProject(simplace)   
varlist <- varmapToList(varmap)
varlist$startdate - 365
varlist$LintulBiomass.sWSO}
}
