% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimplaceWrapper.R
\name{runSimulations}
\alias{runSimulations}
\title{Run the created simulations}
\usage{
runSimulations(simplace, selectsimulation = FALSE)
}
\arguments{
\item{simplace}{handle to the SimplaceWrapper object returned by \code{\link{initSimplace}}}

\item{selectsimulation}{if true keeps a selected simulation}
}
\value{
No return value, called for the side effect of running the simulation
}
\description{
Run the created simulations from the queue. If the queue is empty, the
last created simulation will be run.
}
\examples{
\dontrun{
simplace <- initSimplace(SimplaceInstallationDir,SimplaceWorkDir,SimplaceOutputDir)
openProject(simplace, Solution)
parameters <- list()
parameters$vBaseLUE <- 3.0
s1 <- createSimulation(simplace, parameters,queue=TRUE)
parameters$vBaseLUE <- 3.2
s2 <- createSimulation(simplace, parameters,queue=TRUE)
runSimulations(simplace)
parameters$vBaseLUE <- 2.8
s3 <- createSimulation(simplace, parameters,queue=TRUE)
runSimulations(simplace)

closeProject(simplace)   }
}
\seealso{
\code{\link{createSimulation}}, \code{\link{resetSimulationQueue}}
}
