% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simmr.R
\docType{package}
\name{simmr}
\alias{simmr}
\title{simmr: A package for fitting stable isotope mixing models via JAGS in R}
\description{
This package runs a
simple Stable Isotope Mixing Model (SIMM) and is meant as a longer term
replacement to the previous function SIAR.. These are used to infer dietary
proportions of organisms consuming various food sources from observations on
the stable isotope values taken from the organisms' tissue samples. However
SIMMs can also be used in other scenarios, such as in sediment mixing or the
composition of fatty acids. The main functions are \code{\link{simmr_load}}
and \code{\link{simmr_mcmc}}. The help files contain examples of the use of
this package. See also the vignette for a longer walkthrough.
}
\details{
An even longer term replacement for properly running SIMMs is MixSIAR, which
allows for more detailed random effects and the inclusion of covariates.
}
\examples{

\dontrun{
# A first example with 2 tracers (isotopes), 10 observations, and 4 food sources
data(geese_data_day1)
simmr_in <- with(
  geese_data_day1,
  simmr_load(
    mixtures = mixtures,
    source_names = source_names,
    source_means = source_means,
    source_sds = source_sds,
    correction_means = correction_means,
    correction_sds = correction_sds,
    concentration_means = concentration_means
  )
)

# Plot
plot(simmr_in)

# MCMC run
simmr_out <- simmr_mcmc(simmr_in)

# Check convergence - values should all be close to 1
summary(simmr_out, type = "diagnostics")

# Look at output
summary(simmr_out, type = "statistics")

# Look at influence of priors
prior_viz(simmr_out)

# Plot output
plot(simmr_out, type = "histogram")
}
}
\references{
Andrew C. Parnell, Donald L. Phillips, Stuart Bearhop, Brice X.
Semmens, Eric J. Ward, Jonathan W. Moore, Andrew L. Jackson, Jonathan Grey,
David J. Kelly, and Richard Inger. Bayesian stable isotope mixing models.
Environmetrics, 24(6):387–399, 2013.

Andrew C Parnell, Richard Inger, Stuart Bearhop, and Andrew L Jackson.
Source partitioning using stable isotopes: coping with too much variation.
PLoS ONE, 5(3):5, 2010.
}
\author{
Andrew Parnell <andrew.parnell@mu.ie>
}
\keyword{multivariate}
