% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simml-main.R
\name{fit.simml}
\alias{fit.simml}
\title{Single-index models with multiple-links (the workhorse function)}
\usage{
fit.simml(y, Tr, X, mu.hat = NULL, family = "gaussian",
  ortho.constr = TRUE, bs = "ps", k = 8, alpha.ini = NULL,
  ind.to.be.positive = 1, pen.order = 0, lambda = 0, max.iter = 30,
  eps.iter = 0.01, trace.iter = TRUE)
}
\arguments{
\item{y}{a n-by-1 vector of treatment outcomes; y is assumed to follow an exponential family distribution; any distribution supported by \code{mgcv::gam}.}

\item{Tr}{a n-by-1 vector of treatment indicators; each element represents one of the L(>1) treatment conditions; e.g., c(1,2,1,1,1...); can be a factor-valued.}

\item{X}{a n-by-p matrix of pre-treatment covarates.}

\item{mu.hat}{a n-by-1 vector for efficinecy augmentation provided by the user; the defult is \code{NULL}; the optimal choice for this vector is h(E(y|X)), where h is the canonical link function.}

\item{family}{specifies the distribution of y; e.g., "gaussian", "binomial", "poisson"; the defult is "gaussian"; can be any family supported by \code{mgcv::gam}.}

\item{ortho.constr}{separates the interaction effects from the main effect (without this, the interaction effect can be confounded by the main effect; the default is \code{TRUE}.}

\item{bs}{type of basis for representing the treatment-specific smooths; the defult is "ps" (p-splines); any basis supported by \code{mgcv::gam} can be used, e.g., "cr" (cubic regression splines)}

\item{k}{basis dimension; the same number (k) is used for all treatment groups, however, the smooths of different treatments have different roughness parameters.}

\item{alpha.ini}{an initial solution of \code{alpha.coef}; a p-by-1 vector; the defult is \code{NULL}.}

\item{ind.to.be.positive}{for identifiability of the solution \code{alpha.coef}, we restrict the jth component of \code{alpha.coef} to be positive; by default \code{j=1}.}

\item{pen.order}{0 indicates the ridge penalty; 1 indicates the 1st difference penalty; 2 indicates the 2nd difference penalty, used in a penalized least squares (LS) estimation of \code{alpha.coef}.}

\item{lambda}{a regularziation parameter associated with the penalized LS of \code{alpha.coef}.}

\item{max.iter}{an integer specifying the maximum number of iterations for \code{alpha.coef} update.}

\item{eps.iter}{a value specifying the convergence criterion of algorithm.}

\item{trace.iter}{if \code{TRUE}, trace the estimation process and print the differences in \code{alpha.coef}.}
}
\value{
a list of information of the fitted SIMML including
 \item{alpha.coef}{ the estimated single-index coefficients.} \item{g.fit}{a \code{mgcv:gam} object containing information about the estimated treatment-specific link functions.} \item{alpha.ini}{the initial value used in the estimation of \code{alpha.coef}} \item{alpha.path}{solution path of \code{alpha.coef} over the iterations} \item{d.alpha}{records the magnitude of change in \code{alpha.coef} over the solution path, \code{alpha.path}} \item{scale.X}{sd of pretreatment covariates X} \item{center.X}{mean of pretreatment covariates X} \item{L}{number of different treatment options} \item{p}{number of pretreatment covariates X} \item{n}{number of subjects}
}
\description{
\code{fit.simml} is the workhorse function for Single-index models with multiple-links (SIMML).
The function estimates a linear combination (a single-index) of covariates X, and models the treatment-specific outcome y, via treatment-specific nonparametrically-defined link functions.
}
\details{
SIMML captures the effect of covariates via a single-index and their interaction with the treatment via nonparametric link functions.
Interaction effects are determined by distinct shapes of the link functions.
The estimated single-index is useful for comparing differential treatment efficacy.
The resulting \code{simml} object can be used to estimate an optimal treatment decision rule
for a new patient with pretreatment clinical information.
}
\seealso{
\code{pred.simml},  \code{fit.simml}
}
\author{
Park, Petkova, Tarpey, Ogden
}
