% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory-activities.R
\name{set_prioritization}
\alias{set_prioritization}
\title{Set Prioritization Values}
\usage{
set_prioritization(.trj, values, mod = c(NA, "+", "*"))
}
\arguments{
\item{.trj}{the trajectory object.}

\item{values}{expects either a vector/list or a callable object (a function)
returning a vector/list of three values \code{c(priority, preemptible, restart)}.
A negative value leaves the corresponding parameter unchanged.
See \code{\link{add_generator}} for more information about these parameters.}

\item{mod}{if set, \code{values} modify the attributes rather than substituting them.}
}
\value{
Returns the trajectory object.
}
\description{
Activity for dynamically modifying an arrival's prioritization values.
Default prioritization values are defined by the source (see
\code{\link{add_generator}}, \code{\link{add_dataframe}}).
}
\examples{
traj <- trajectory() \%>\%

  # static values
  set_prioritization(c(3, 7, TRUE)) \%>\%

  # increment
  set_prioritization(c(2, 1, 0), mod="+") \%>\%

  # dynamic, custom
  set_attribute("priority", 3) \%>\%
  set_prioritization(function() {
    prio <- get_prioritization(env)
    attr <- get_attribute(env, "priority")
    c(attr, prio[[2]]+1, FALSE)
  })

}
\seealso{
\code{\link{get_prioritization}}
}
