% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delayed_release.R
\name{delayed_release}
\alias{delayed_release}
\alias{delayed_release_selected}
\title{Delayed Release of a Resource}
\usage{
delayed_release(.trj, resource, task, amount = 1, preemptive = FALSE,
  mon_all = FALSE)

delayed_release_selected(.trj, task, amount = 1, preemptive = FALSE,
  mon_all = FALSE)
}
\arguments{
\item{.trj}{the trajectory object.}

\item{resource}{the name of the resource.}

\item{task}{the timeout duration supplied by either passing a numeric or a
callable object (a function) which must return a numeric (negative values are
automatically coerced to positive).}

\item{amount}{the amount to seize/release, accepts either a numeric or a
callable object (a function) which must return a numeric.}

\item{preemptive}{whether arrivals in the server can be preempted or not based
on seize priorities.}

\item{mon_all}{if \code{TRUE}, \code{get_mon_arrivals} will show one
line per clone.}
}
\value{
Returns the following chain of activities: \code{\link[simmer]{clone}}
> \code{\link[simmer:clone]{synchronize}} (see examples below).
}
\description{
This brick encapsulates a delayed release: the arrival releases the resource
and continues its way immediately, but the resource is busy for an additional
period of time.
}
\examples{
## These are equivalent for a non-preemptive resource:
trajectory() \%>\%
  delayed_release("res1", 5, 1)

trajectory() \%>\%
  clone(
    2,
    trajectory() \%>\%
      set_capacity("res1", -1, mod="+") \%>\%
      release("res1", 1),
    trajectory() \%>\%
      timeout(5) \%>\%
      set_capacity("res1", 1, mod="+")
  ) \%>\%
  synchronize(wait=FALSE)

## These are equivalent for a preemptive resource:
trajectory() \%>\%
  delayed_release("res2", 5, 1, preemptive=TRUE)

trajectory() \%>\%
  clone(
    2,
    trajectory() \%>\%
      release("res2", 1),
    trajectory() \%>\%
      set_prioritization(c(rep(.Machine$integer.max, 2), 0)) \%>\%
      seize("res2", 1) \%>\%
      timeout(5) \%>\%
      release("res2", 1)
  ) \%>\%
  synchronize(wait=FALSE)

}
