% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pow_sim.r
\name{sim_pow_nested}
\alias{sim_pow_nested}
\title{Power simulation for nested designs}
\usage{
sim_pow_nested(fixed, random, fixed_param, random_param = list(),
  cov_param, n, p, error_var, with_err_gen, arima = FALSE, data_str,
  cor_vars = NULL, fact_vars = list(NULL), unbal = FALSE,
  unbal_design = NULL, lvl1_err_params = NULL,
  arima_mod = list(NULL), contrasts = NULL, homogeneity = TRUE,
  heterogeneity_var = NULL, cross_class_params = NULL,
  knot_args = list(NULL), missing = FALSE, missing_args = list(NULL),
  pow_param = NULL, alpha, pow_dist = c("z", "t"), pow_tail = c(1,
  2), lme4_fit_mod = NULL, nlme_fit_mod = NULL, arima_fit_mod = NULL,
  general_mod = NULL, general_extract = NULL, ...)
}
\arguments{
\item{fixed}{One sided formula for fixed effects in the simulation. 
To suppress intercept add -1 to formula.}

\item{random}{One sided formula for random effects in the simulation. 
Must be a subset of fixed.}

\item{fixed_param}{Fixed effect parameter values (i.e. beta weights). 
Must be same length as fixed.}

\item{random_param}{A list of named elements that must contain: 
\itemize{
   \item  random_var: variance of random parameters,
   \item  rand_gen: Name of simulation function for random effects.
}
       Optional elements are:
\itemize{
   \item ther: Theorectial mean and variance from rand_gen,
   \item ther_sim: Simulate mean/variance for standardization purposes,
   \item cor_vars: Correlation between random effects,
   \item ...: Additional parameters needed for rand_gen function.
 }}

\item{cov_param}{List of arguments to pass to the continuous generating 
function, must be the same order as the variables specified in fixed. 
This list does not include intercept, time, factors, or 
interactions. Required arguments include:
\itemize{
  \item dist_fun: This is a quoted R distribution function.
  \item var_type: This is the level of variable to generate. Must be 
    'level1' or 'level2'. 
    Must be same order as fixed formula above.
}
Optional arguments to the distribution functions are in a nested list,
 see the examples or vignettes for example code.}

\item{n}{Cluster sample size.}

\item{p}{Within cluster sample size.}

\item{error_var}{Scalar of error variance.}

\item{with_err_gen}{Simulated within cluster error distribution. 
Must be a quoted 'r' distribution function.}

\item{arima}{TRUE/FALSE flag indicating whether residuals should 
be correlated. If TRUE, must specify a valid model to pass to 
arima.sim via the arima_mod argument. 
See \code{\link{arima.sim}} for examples.}

\item{data_str}{Type of data. Must be "cross", "long", or "single".}

\item{cor_vars}{A vector of correlations between variables.}

\item{fact_vars}{A nested list of factor, categorical, or ordinal variable 
   specification, each list must include:
\itemize{
     \item numlevels: Number of levels for ordinal or factor variables.
     \item var_type: Must be 'level1' or 'level2'.
 }
 Optional arguments include:
 \itemize{
     \item replace
     \item prob
     \item value.labels
 }
  See also \code{\link{sample}} for use of these optional arguments.}

\item{unbal}{A vector of sample sizes for the number of observations for 
each level 2 cluster. Must have same length as level two sample size n. 
Alternative specification can be TRUE, which uses additional argument, 
unbal_design.}

\item{unbal_design}{When unbal = TRUE, this specifies the design for unbalanced
simulation in one of two ways. It can represent the minimum and maximum 
sample size within a cluster via a named list. This will be drawn from a 
random uniform distribution with min and max specified. 
Secondly, the sample sizes within each cluster can be specified. 
This takes the form of a vector that must have the same length 
as the level two sample size.}

\item{lvl1_err_params}{Additional parameters passed as a list on to the level
one error generating function}

\item{arima_mod}{A list indicating the ARIMA model to pass to arima.sim. 
See \code{\link{arima.sim}} for examples.}

\item{contrasts}{An optional list that specifies the contrasts to be used 
for factor variables (i.e. those variables with .f or .c). 
See \code{\link{contrasts}} for more detail.}

\item{homogeneity}{Either TRUE (default) indicating homogeneity of variance
assumption is assumed or FALSE to indicate desire to generate heterogeneity 
of variance.}

\item{heterogeneity_var}{Variable name as a character string to use for 
heterogeneity of variance simulation.}

\item{cross_class_params}{A list of named parameters when cross classified 
data structures are desired. Must include the following arguments:
 \itemize{
  \item num_ids: The number of cross classified clusters. These are in 
       addition to the typical cluster ids
  \item random_param: This argument is a list of arguments passed to 
     \code{\link{sim_rand_eff}}. These must include:
    \itemize{
     \item random_var: The variance of the cross classified random effect
     \item rand_gen: The random generating function used to generate the 
        cross classified random effect.
    }
    Optional elements are:
  \itemize{
      \item ther: Theorectial mean and variance from rand_gen,
      \item ther_sim: Simulate mean/variance for standardization purposes,
      \item cor_vars: Correlation between random effects,
      \item ...: Additional parameters needed for rand_gen function.
  } 
 }}

\item{knot_args}{A nested list of named knot arguments. See \code{\link{sim_knot}} 
for more details. Arguments must include:
  \itemize{
    \item var
    \item knot_locations
  }}

\item{missing}{TRUE/FALSE flag indicating whether missing data should be 
simulated.}

\item{missing_args}{Additional missing arguments to pass to the missing_data 
function. See \code{\link{missing_data}} for examples.}

\item{pow_param}{Name of variable to calculate power for, must be a name 
from fixed.}

\item{alpha}{What should the per test alpha rate be used for the hypothesis 
testing.}

\item{pow_dist}{Which distribution should be used when testing hypothesis 
test, z or t?}

\item{pow_tail}{One-tailed or two-tailed test?}

\item{lme4_fit_mod}{Valid lme4 syntax to be used for model fitting.}

\item{nlme_fit_mod}{Valid nlme syntax to be used for model fitting. 
This should be specified as a named list with fixed and random components.}

\item{arima_fit_mod}{Valid nlme syntax for fitting serial correlation structures.
See \code{\link{corStruct}} for help. This must be specified to 
include serial correlation.}

\item{general_mod}{Valid model syntax. This syntax can be from any R package. 
By default, broom is used to extract model result information. Note, 
package must be defined or loaded prior to running the sim_pow function.}

\item{general_extract}{A valid function to extract model results if 
general_mod argument is used. This argument is primarily used if extracting model
results is not possibly using the broom package. If this is left NULL (default), 
broom is used to collect model results.}

\item{...}{Not currently used.}
}
\description{
Takes simulation conditions as input, exports power.
}
\details{
Power function to compute power for a regression term for the linear 
mixed model. This function would need to be replicated to make any statement 
about power.  Use \code{\link{sim_pow}} as a convenient wrapper for this.
}
\seealso{
\code{\link{sim_pow}} for a wrapper to replicate.
}
