% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/simcausal.r
\name{plotDAG}
\alias{plotDAG}
\title{Plot DAG}
\usage{
plotDAG(DAG, tmax = NULL, xjitter, yjitter, node.action.color,
  vertex_attrs = list(), edge_attrs = list(), excludeattrs, customvlabs)
}
\arguments{
\item{DAG}{A DAG object that was specified by calling \code{\link{set.DAG}}}

\item{tmax}{Maximum time-point to plot for time-varying DAG objects}

\item{xjitter}{Amount of random jitter for node x-axis plotting coordinates}

\item{yjitter}{Amount of random jitter for node y-axis plotting coordinates}

\item{node.action.color}{Color of the action node labels (only for action DAG of class DAG.action). If missing, defaults to red.}

\item{vertex_attrs}{A named list of \code{igraph} graphical parameters for plotting DAG vertices. These parameters are passed on to \code{add.vertices} \code{igraph} function.}

\item{edge_attrs}{A named list of \code{igraph} graphical parameters for plotting DAG edges. These parameters are passed on to \code{add.edges} \code{igraph} function.}

\item{excludeattrs}{A character vector of attribute DAG nodes that shouldn't be plotted}

\item{customvlabs}{A named vector of custom DAG node labels (replaces node names from the DAG object).}
}
\description{
Plot a DAG object using functions from \code{igraph} package.
}

