% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zscore.R
\name{simulated_z_null}
\alias{simulated_z_null}
\title{Compute a NULL simulated Z Score}
\usage{
simulated_z_null(snps, freq, nrep = 1)
}
\arguments{
\item{snps}{The snps at which we wish to compute the expected Z Score}

\item{freq}{Haplotype frequencies as a data.frame, with column Probability indicating relative frequency in controls.}

\item{nrep}{Number of replicates (simulated vectors of Z scores)
under this scenario.  Default=1}
}
\description{
Compute matrix of simulated Z scores about expected values of 0 -
ie under a null of no association at any SNP
}
\examples{
freq=fake_freq(nhaps=100,nsnps=5) # fake haplotype frequency data
    Z=simulated_z_null(snps=paste0("s",1:5),freq=freq,nrep=3)
Z # no causal variants
}
\author{
Mary Fortune and Chris Wallace
}
