% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_meteorlogy.R
\name{cal_netLongwaveRadiation}
\alias{cal_netLongwaveRadiation}
\title{Calculating net longwave radiation Rnl}
\usage{
cal_netLongwaveRadiation(TKmax, TKmin, ea, Rs, Rso)
}
\arguments{
\item{TKmax}{maximum absolute temperature during the 24-hour period [K].}

\item{TKmin}{minimum absolute temperature during the 24-hour period [K].}

\item{ea}{actual vapour pressure [kPa].}

\item{Rs}{measured or calculated solar radiation [MJ m-2 day-1].
From cal_solarRadiation().}

\item{Rso}{calculated clear-sky radiation [MJ m-2 day-1].
From cal_skySolarRadiation_withas_bs() or cal_skySolarRadiation_withas_elevation().}
}
\value{
A vector for net outgoing longwave radiation [MJ m-2 day-1]
}
\description{
Calculating net longwave radiation Rnl
}
\note{
The rate of longwave energy emission is proportional to the absolute
   temperature of the surface raised to the fourth power. This relation is
   expressed quantitatively by the Stefan-Boltzmann law. The net energy flux
   leaving the earth's surface is, however, less than that emitted and given
   by the Stefan-Boltzmann law due to the absorption and downward radiation
   from the sky. Water vapour, clouds, carbon dioxide and dust are absorbers
   and emitters of longwave radiation. Their concentrations should be known
   when assessing the net outgoing flux. As humidity and cloudiness play an
   important role, the Stefan-Boltzmann law is corrected by these two factors
   when estimating the net outgoing flux of longwave radiation. It is thereby
   assumed that the concentrations of the other absorbers are constant. An
   average of the maximum air temperature to the fourth power and the minimum
   air temperature to the fourth power is commonly used in the Stefan-Boltzmann
   equation for 24-hour time steps. The term (0.34-0.14*sqrt(ea)) expresses
   the correction for air humidity, and will be smaller if the humidity increases.
   The effect of cloudiness is expressed by (1.35 Rs/Rso - 0.35). The term
   becomes smaller if the cloudiness increases and hence Rs decreases. The
   smaller the correction terms, the smaller the net outgoing flux of longwave
   radiation.  Note that the Rs/Rso term in Equation 39 must be limited so that
   Rs/Rso <= 1.0. Where measurements of incoming and outgoing short and longwave
   radiation during bright sunny and overcast hours are available, calibration
   of the coefficients in Equation 39 can be carried out.
}
\references{
Allen, R. G., Pereira, L. S., Raes, D., & Smith, M.
   FAO Irrigation and drainage paper No. 56. Rome: Food and Agriculture
   Organization of the United Nations, 1998.
}
