% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EmpiricalFns.R
\name{resampleScoreModelPair}
\alias{resampleScoreModelPair}
\title{Studentized bootstrap test of strength of scoreFn(yValues,model1Values) > scoreFn(yValues,model1Values).}
\usage{
resampleScoreModelPair(model1Values, model2Values, yValues, scoreFn, ...,
  returnScores = FALSE, nRep = 100, parallelCluster = NULL,
  sameSample = FALSE)
}
\arguments{
\item{model1Values}{numeric array of predictions (model to test).}

\item{model2Values}{numeric array of predictions (reference model).}

\item{yValues}{numeric/logical array of outcomes, depedendent, or truth values}

\item{scoreFn}{function with signature scoreFn(modelValues,yValues) returning scalar numeric score.}

\item{...}{not used, forces later arguments to be bound by name.}

\item{returnScores}{logical if TRUE return detailed resampledScores.}

\item{nRep}{integer number of repititions to perform.}

\item{parallelCluster}{optional snow-style parallel cluster.}

\item{sameSample}{logical if TRUE use the same sample in computing both scores during bootstrap replication (else use independent samples).}
}
\value{
summaries
}
\description{
True confidence intervals are harder to get right (see
"An Introduction to the Bootstrap", Bradely Efron,
and Robert J. Tibshirani, Chapman & Hall/CRC, 1993.),
but we will settle for simple p-value estimates.
}
\examples{

set.seed(25325)
y <- 1:5
m1 <- c(1,1,2,2,2)
m2 <- c(1,1,1,1,2)
cor(m1,y)
cor(m2,y)
f <- function(modelValues,yValues) {
  if((sd(modelValues)<=0)||(sd(yValues)<=0)) {
    return(0)
  }
  cor(modelValues,yValues)
}
resampleScoreModelPair(m1,m2,y,f)

}

