% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_cn_components.R
\name{show_cn_components}
\alias{show_cn_components}
\title{Show Copy Number Components}
\usage{
show_cn_components(
  parameters,
  method = "Macintyre",
  show_weights = TRUE,
  log_segsize = TRUE,
  log_y = FALSE,
  auto_transform = TRUE,
  return_plotlist = FALSE,
  base_size = 12,
  nrow = 2,
  align = "hv",
  ...
)
}
\arguments{
\item{parameters}{a \code{data.frame} contain parameter components, obtain this
from \link{sig_tally} function.}

\item{method}{method for feature classfication, can be one of "Macintyre" ("M"),
"Wang" ("W") and "Tao & Wang" ("T").}

\item{show_weights}{default is \code{TRUE}, show weights for each component.
Only used when method is "Macintyre".}

\item{log_segsize}{default is \code{TRUE}, show \code{log10} based segsize, only
works for input from "Macintyre" ("M") method.}

\item{log_y}{logical, if \code{TRUE}, show \code{log10} based y axis, only
works for input from "Wang" ("W") method.}

\item{auto_transform}{default is \code{TRUE}, it will auto increase the \code{SD} for components
for showing them better in the plot. Only used when method is "Macintyre".}

\item{return_plotlist}{if \code{TRUE}, return a list of ggplot objects but a combined plot.}

\item{base_size}{overall font size.}

\item{nrow}{(optional) Number of rows in the plot grid.}

\item{align}{(optional) Specifies whether graphs in the grid should be horizontally ("h") or
vertically ("v") aligned. Options are "none" (default), "hv" (align in both directions), "h", and "v".}

\item{...}{other options pass to \code{\link[cowplot]{plot_grid}} function of \strong{cowplot} package.}
}
\value{
a \code{ggplot} object
}
\description{
Show mixture fit model components ("Macintyre" ("M") method) or
standard classified components ("Wang" ("W") method) for copy number data.
}
\examples{
load(system.file("extdata", "toy_copynumber_tally_M.RData",
  package = "sigminer", mustWork = TRUE
))
p1 <- show_cn_components(cn_tally_M$parameters)
p1
p2 <- show_cn_components(cn_tally_M$parameters, show_weights = FALSE)
p2

load(system.file("extdata", "toy_copynumber_tally_W.RData",
  package = "sigminer", mustWork = TRUE
))
p3 <- show_cn_components(cn_tally_W$parameters, method = "W")
p3
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
