% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_all_plots.R
\name{make_all_plots}
\alias{make_all_plots}
\title{make_all_plots.R}
\usage{
make_all_plots(gene_sigs_list, mRNA_expr_matrix, names_sigs = NULL,
  names_datasets = NULL, covariates = NULL, thresholds = NULL,
  out_dir = tempdir(), showResults = TRUE, origin = NULL,
  doNegativeControl = TRUE, numResampling = 50)
}
\arguments{
\item{gene_sigs_list}{A list of genes representing the gene signatures to be tested. Each element of this list is a k-by-1 character matrix of k genes, which comprise the gene signature. Genes must be annotated in the same way as the rows of the data matrix.}

\item{mRNA_expr_matrix}{A list of matrices of expression values for the datasets to be considered. One numeric matrix entry per dataset. The rows are to be labelled as the genes, all annotated in the same way, and columns are sample IDs. Expression values should be transformed/cleaned as needed prior to use in sigQC. We recommend normalisation, batch correction, and log-transformation prior to use.}

\item{names_sigs}{The names of the gene signatures (e.g. Hypoxia, Invasiveness), one name per each signature in gene_sigs_list. Corresponds to the names of the entries of the list.}

\item{names_datasets}{The names of the different datasets contained in mRNA_expr_matrix. Corresponds to the names of the entries of the list.}

\item{covariates}{A list containing a sub-list of 'annotations' and 'colors' which contains the annotation matrix for the given dataset and the associated colours with which to plot in the expression heatmap. This is in the same form as used by the ComplexHeatmap package.}

\item{thresholds}{A list of expression thresholds to be considered for each data set, default is median of the data set. A gene is considered expressed if above the threshold, non-expressed otherwise. One threshold per dataset, in the same order as the dataset list. Note that this is only used for the reporting of the genes showing supra-threshold expression across each dataset.}

\item{out_dir}{A path to the directory where the resulting output files are written.}

\item{showResults}{Tells if open dialog boxes showing the computed results. Default is FALSE.}

\item{origin}{Tells if datasets have come from different labs/experiments/machines. Is a vector of characters, with same character representing same origin. Default is assumption that all datasets come from the same source. Used in the correction of batch effects during the RankProduct computation for poorly auto-correlated signature genes. Only to be used if multiple datasets are present.}

\item{doNegativeControl}{Logical, tells the function if negative controls must be computed. TRUE by default.}

\item{numResampling}{Number of bootstrap re-samplings of random gene signatures of the same length (50 by default) from which to compute null distribution of each metric.}
}
\description{
Makes all the plots for the quality control of the list(s) of genes.
}
\examples{
library(sigQC)
names = c("dataset1")
data.matrix = replicate(10, rnorm(20))#random matrix - 10 genes x 20 samples
mRNA_expr_matrix = list()
mRNA_expr_matrix[["dataset1"]] = data.matrix
row.names(mRNA_expr_matrix$dataset1) <- as.character(1:(dim(mRNA_expr_matrix$dataset1)[1]))
colnames(mRNA_expr_matrix$dataset1) <- as.character(1:(dim(mRNA_expr_matrix$dataset1)[2]))
#Define the signature
gene_sigs_list = list()
signature = "hypoxiaSig"
gene_sig = c('1', '4', '5')#gene ids
gene_sigs_list[[signature]] = as.matrix(gene_sig)
names_sigs = c(signature)
make_all_plots(gene_sigs_list = gene_sigs_list, mRNA_expr_matrix = mRNA_expr_matrix, 
    doNegativeControl=FALSE, out_dir = tempdir(), showResults=FALSE)
}
\keyword{make_all_plots}
