% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineFitFunctions.R
\name{lineFitFormula}
\alias{lineFitFormula}
\title{Line fit formula.}
\usage{
lineFitFormula(x, slope, intersection)
}
\arguments{
\item{x}{the "time" (time) column of the dataframe.}

\item{slope}{the slope of the line.}

\item{intersection}{the intensity intersection point of the line when time is zero in the time-intensity graph.}
}
\value{
Returns the predicted intensities for given time points in the line fit model for given slope and intersection values.
}
\description{
Calculates intesities for given time points (x) by using line fit model and parameters (slope and intersection).
}
\examples{
time=seq(3,24,0.5)

#simulate intensity data and add noise
noise_parameter=.2
intensity_noise=stats::runif(n = length(time),min = 0,max = 1)*noise_parameter
intensity=lineFitFormula(time, slope=4, intersection=-2)
intensity=intensity+intensity_noise

dataInput=data.frame(intensity=intensity,time=time)
normalizedInput = normalizeData(dataInput)
parameterVector<-lineFitFunction(normalizedInput,tryCounter=2)

#Check the results
if(parameterVector$isThisaFit){
 intensityTheoretical=lineFitFormula(time,
                                     slope=parameterVector$slope_Estimate,
                                     intersection=parameterVector$intersection_Estimate)

 comparisonData=cbind(dataInput,intensityTheoretical)

 print(parameterVector$residual_Sum_of_Squares)

 require(ggplot2)
 ggplot(comparisonData)+
   geom_point(aes(x=time, y=intensity))+
   geom_line(aes(x=time,y=intensityTheoretical))+
   expand_limits(x = 0, y = 0)}

if(!parameterVector$isThisaFit){print(parameterVector)}


}

