% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/videos.R
\name{getVideoDetails}
\alias{getVideoDetails}
\title{Get details about videos}
\source{
\dQuote{\code{/videos/\{id\}}}
}
\usage{
getVideoDetails(id, ...)
}
\arguments{
\item{id}{character. One or more Video IDs.}

\item{...}{arguments to be passed by the source endpoint parameters.}
}
\description{
Get details about videos
}
\examples{
\dontrun{
# get details of a single video:
getVideoDetails(id = "18002566")

# multiple videos by lapply:
lapply(c("18002566", "17139196"), function(v) getVideoDetails(id = v))

# get multiple videos by for loop:
videos <- list()
for (v in c("18002566", "17139196")) {
videos[[v]] <- getVideoDetails(id = v)
}
}
}
