#
#   shopifyr: An R Interface to the Shopify API
#
#   Copyright (C) 2015 Charlie Friedemann cfriedem @ gmail.com
#   Shopify API (c) 2006-2015 Shopify Inc.
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

########### OrderRisks functions ########### 
#' @param orderId an \code{\link{Order}} id number
#' @templateVar name OrderRisks
#' @templateVar slug orderRisk
#' @templateVar urlSlug orders/order_risk
#' @template api
NULL

## POST /admin/api/#{api_version}/orders/#{id}/risks.json
## Create a new Order Risks
#' @rdname OrderRisks
createOrderRisk <- function(orderId, orderRisk, ...) {
    orderRisk <- private$.wrap(orderRisk, "risk", check=FALSE)
    private$.request(private$.url("orders",orderId,"risks"), reqType="POST", data=orderRisk, ...)$risk
}

## GET /admin/api/#{api_version}/orders/#{id}/risks.json
## Receive a list of all Order Risks
#' @rdname OrderRisks
getOrderRisks <- function(orderId, ...) {
    private$.request(private$.url("orders",orderId,"risks"), ...)$risks
}

## GET /admin/api/#{api_version}/orders/#{id}/risks/#{id}.json
## Receive a single Order Risk
#' @rdname OrderRisks
getOrderRisk <- function(orderId, orderRiskId, ...) {
    private$.request(private$.url("orders",orderId,"risks",orderRiskId), ...)$risk
}

## PUT /admin/api/#{api_version}/orders/#{id}/risks/#{id}.json
## Modify an existing Order Risks
#' @rdname OrderRisks
modifyOrderRisk <- function(orderId, orderRisk, ...) {
    orderRisk <- private$.wrap(orderRisk, "risk")
    private$.request(private$.url("orders",orderId,"risks",orderRisk$risk$id), reqType="PUT", data=orderRisk, ...)$risk
}

## DELETE /admin/api/#{api_version}/orders/#{id}/risks/#{id}.json
## Remove a Order Risks from the database
#' @rdname OrderRisks
deleteOrderRisk <- function(orderId, orderRiskId, ...) {
    private$.request(private$.url("orders",orderId,"risks",orderRiskId), reqType="DELETE", ...)
}