% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ames_mlp_itr}
\alias{ames_mlp_itr}
\title{Iterative optimization of neural network}
\value{
An object with primary class \code{iteration_results}.
}
\description{
This object has the results when a neural network was tuned using Bayesian
optimization and a validation set.
}
\details{
The code used to produce this object:\preformatted{  data(ames)

  ames <-
    ames \%>\%
    select(Sale_Price, Neighborhood, Longitude, Latitude, Year_Built) \%>\%
    mutate(Sale_Price = log10(ames$Sale_Price))

  set.seed(1)
  ames_rs <- validation_split(ames)

  ames_rec <-
    recipe(Sale_Price ~ ., data = ames) \%>\%
    step_dummy(all_nominal_predictors()) \%>\%
    step_zv(all_predictors()) \%>\%
    step_normalize(all_predictors())

  mlp_spec <-
    mlp(hidden_units = tune(),
        penalty = tune(),
        epochs = tune()) \%>\%
    set_mode("regression")

  set.seed(1)
  ames_mlp_itr <-
    mlp_spec \%>\%
    tune_bayes(
      ames_rec,
      resamples = ames_rs,
      initial = 5,
      iter = 4,
      control = control_bayes(save_pred = TRUE)
    )
}
}
\keyword{datasets}
