% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secure-app.R
\name{secure-app}
\alias{secure-app}
\alias{secure_app}
\alias{secure_server}
\title{Secure a Shiny application and manage authentication}
\usage{
secure_app(ui, ..., enable_admin = FALSE, head_auth = NULL,
  theme = NULL, language = "en")

secure_server(check_credentials, timeout = 15,
  session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{ui}{UI of the application.}

\item{...}{Arguments passed to \code{\link{auth_ui}}.}

\item{enable_admin}{Enable or not access to admin mode, note that
admin mode is only available when using SQLite backend for credentials.}

\item{head_auth}{Tag or list of tags to use in the \code{<head>}
of the authentication page (for custom CSS for example).}

\item{theme}{Alternative Bootstrap stylesheet, default is to use \code{readable},
you can use themes provided by \code{shinythemes}.
It will affect the authentication panel and the admin page.}

\item{language}{Language to use for labels, supported values are : "en", "fr".}

\item{check_credentials}{Function passed to \code{\link{auth_server}}.}

\item{timeout}{Timeout session (minutes) before logout if sleeping. Defaut to 15. 0 to disable.}

\item{session}{Shiny session.}
}
\value{
A \code{reactiveValues} containing informations about the user connected.
}
\description{
Secure a Shiny application and manage authentication
}
\note{
A special input value will be accessible server-side with \code{input$shinymanager_where}
 to know in which step user is : authentication, application, admin or password.
}
\examples{
if (interactive()) {

  # define some credentials
  credentials <- data.frame(
    user = c("shiny", "shinymanager"),
    password = c("azerty", "12345"),
    stringsAsFactors = FALSE
  )

  library(shiny)
  library(shinymanager)

  ui <- fluidPage(
    tags$h2("My secure application"),
    verbatimTextOutput("auth_output")
  )

  # Wrap your UI with secure_app
  ui <- secure_app(ui)


  server <- function(input, output, session) {

    # call the server part
    # check_credentials returns a function to authenticate users
    res_auth <- secure_server(
      check_credentials = check_credentials(credentials)
    )

    output$auth_output <- renderPrint({
      reactiveValuesToList(res_auth)
    })

    # your classic server logic

  }

  shinyApp(ui, server)

}
}
