% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sortableCheckboxGroupInput.R
\name{sortableCheckboxGroupInput}
\alias{sortableCheckboxGroupInput}
\title{Create a Checkbox Group Input Control with Sortable Choices}
\usage{
sortableCheckboxGroupInput(
  inputId,
  label,
  choices = NULL,
  selected = NULL,
  inline = FALSE,
  width = NULL,
  choiceNames = NULL,
  choiceValues = NULL
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{choices}{List of values to show checkboxes for. If elements of the list
are named then that name rather than the value is displayed to the user. If
this argument is provided, then \code{choiceNames} and \code{choiceValues}
must not be provided, and vice-versa. The values should be strings; other
types (such as logicals and numbers) will be coerced to strings.}

\item{selected}{The values that should be initially selected, if any.}

\item{inline}{If \code{TRUE}, render the choices inline (i.e. horizontally)}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link[shiny:validateCssUnit]{validateCssUnit()}}.}

\item{choiceNames}{List of names and values, respectively,
that are displayed to the user in the app and correspond to the each
choice (for this reason, \code{choiceNames} and \code{choiceValues}
must have the same length). If either of these arguments is
provided, then the other \emph{must} be provided and \code{choices}
\emph{must not} be provided. The advantage of using both of these over
a named list for \code{choices} is that \code{choiceNames} allows any
type of UI object to be passed through (tag objects, icons, HTML code,
...), instead of just simple text. See Examples.}

\item{choiceValues}{List of names and values, respectively,
that are displayed to the user in the app and correspond to the each
choice (for this reason, \code{choiceNames} and \code{choiceValues}
must have the same length). If either of these arguments is
provided, then the other \emph{must} be provided and \code{choices}
\emph{must not} be provided. The advantage of using both of these over
a named list for \code{choices} is that \code{choiceNames} allows any
type of UI object to be passed through (tag objects, icons, HTML code,
...), instead of just simple text. See Examples.}
}
\value{
A list of HTML elements that can be added to a UI definition
}
\description{
Render a group of checkboxes with multiple choices toggleable. The choices
are also sortable by drag and drop. In addition to the selected values stored
in \verb{input$<inputId>}, the server will also receive the order of choices in
\verb{input$<inputId>_order}.
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {
  shinyApp(
    ui = fluidPage(
      sortableCheckboxGroupInput("foo", "SortableCheckboxGroupInput",
                                 choices = month.abb),
      verbatimTextOutput("order")
    ),
    server = function(input, output) {
      output$order <- renderPrint({input$foo_order})
    }
  )
}

}
\seealso{
\link[shiny:checkboxGroupInput]{shiny::checkboxGroupInput}, \code{\link[=sortableRadioButtons]{sortableRadioButtons()}},
\code{\link[=sortableTableOutput]{sortableTableOutput()}}, \code{\link[=sortableTabsetPanel]{sortableTabsetPanel()}}
}
