% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disconnectMessage.R
\name{disconnectMessage}
\alias{disconnectMessage}
\title{Show a nice message when a shiny app disconnects or errors}
\usage{
disconnectMessage(
  text = "An error occurred. Please refresh the page and try again.",
  refresh = "Refresh",
  width = 450,
  top = 50,
  size = 22,
  background = "white",
  colour = "#444444",
  overlayColour = "black",
  overlayOpacity = 0.6,
  refreshColour = "#337ab7",
  css = ""
)
}
\arguments{
\item{text}{The text to show in the message.}

\item{refresh}{The text to show in a link that allows the user to refresh the page.
Use \code{refresh = ""} if you don't want to show a refresh link.}

\item{width}{The width of the message box. Must be either an integer, or the string
\code{"full"} to make the message take up the entire page width.}

\item{top}{The distance from the message to the top of the page. Must be either
an integer, or the string \code{"center"} to make the box vertically centered.}

\item{size}{The font size of the text. (integer).}

\item{background}{The background colour of the message box.}

\item{colour}{The colour of the text of the message box.}

\item{overlayColour}{The colour of the overlay to draw on the page behind the message box.
An overlay is used to "grey out" the application and draw attention to the message. Use
\code{overlayOpacity = 0} to disable the overlay.}

\item{overlayOpacity}{The opacity of the overlay, from 0 (fully transparent/not visible) to 1
(fully opaque). Use \code{overlayOpacity = 0} to disable the overlay.}

\item{refreshColour}{The colour of the refresh text link}

\item{css}{Any additional CSS rules to apply to the message box. For example,
\code{css = "padding: 0 !important; border: 3px solid red;"} will remove padding and add a border.
Note that you may need to use the \code{!important} rule to override default styles.}
}
\description{
A shiny app can disconnect for a variety of reasons: an unrecoverable error occurred in
the app, the server went down, the user lost internet connection, or any other reason
that might cause the shiny app to lose connection to its server.\cr\cr
Call \code{disonnectMessage()}
anywhere in a Shiny app's UI to add a nice message when this happens. Works
locally (running Shiny apps within RStudio) and on Shiny servers (such as shinyapps.io,
RStudio Connect, Shiny Server Open Source, Shiny Server Pro).\cr\cr
See the \href{https://daattali.com/shiny/shinydisconnect-demo/}{demo Shiny app} online for examples.\cr\cr
Note that it's not possible to distinguish between errors and timeouts - they will both
show the same message.
}
\details{
You can also use \code{\link[=disconnectMessage2]{disconnectMessage2()}} to use a pre-set combination of parameters
that produces a large centered message.
}
\examples{
if (interactive()) {
  library(shiny)
  shinyApp(
    ui = fluidPage(
      disconnectMessage(),
      actionButton("disconnect", "Disconnect the app")
    ),
    server = function(input, output, session) {
      observeEvent(input$disconnect, {
        session$close()
      })
    }
  )
}
}
