% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dashboardSidebar.R
\name{dashboardSidebar}
\alias{dashboardSidebar}
\alias{updateSidebar}
\title{Create a dashboard sidebar.}
\usage{
dashboardSidebar(
  ...,
  disable = FALSE,
  width = NULL,
  collapsed = FALSE,
  minified = TRUE,
  id = NULL
)

updateSidebar(id, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{...}{Items to put in the sidebar.}

\item{disable}{If \code{TRUE}, the sidebar will be disabled.}

\item{width}{The width of the sidebar. This must either be a number which
specifies the width in pixels, or a string that specifies the width in CSS
units.}

\item{collapsed}{If \code{TRUE}, the sidebar will be collapsed on app startup.}

\item{minified}{Whether to slightly close the sidebar but still show item icons. Default
to TRUE.}

\item{id}{Sidebar id.}

\item{session}{Shiny session object.}
}
\description{
A dashboard sidebar typically contains a \code{\link[shinydashboard]{sidebarMenu}}, although
it may also contain a \code{\link[shinydashboard]{sidebarSearchForm}}, or other Shiny inputs.

\link{updateSidebar} allows to toggle a \link{dashboardSidebar} on the client.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 library(shinydashboardPlus)
 
 shinyApp(
   ui = dashboardPage(
     header = dashboardHeader(),
     sidebar = dashboardSidebar(id = "sidebar"),
     body = dashboardBody(
       actionButton(inputId = "sidebarToggle", label = "Toggle Sidebar")
     )
   ),
   server = function(input, output, session) {
     
     observeEvent(input$sidebar, {
       if (input$sidebar) {
         showModal(modalDialog(
           title = "Alert",
           "The sidebar is opened.",
           easyClose = TRUE,
           footer = NULL
         ))
       }
     })
     
     observeEvent(input$sidebarToggle, {
       updateSidebar("sidebar")
     })
     
     observe({
       print(input$sidebar)
     })
   }
 )
}
}
