% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/valueBoxOutput.R
\name{renderValueBox}
\alias{renderInfoBox}
\alias{renderValueBox}
\title{Create an info or value box output (server side)}
\usage{
renderValueBox(expr, env = parent.frame(), quoted = FALSE)

renderInfoBox(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{expr}{An expression that returns a Shiny tag object, \code{\link{HTML}},
or a list of such objects.}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\description{
This is the server-side function for creating a dynamic
\code{\link{valueBox}} or \code{\link{infoBox}}.
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {
library(shiny)

ui <- dashboardPage(
  dashboardHeader(title = "Dynamic boxes"),
  dashboardSidebar(),
  dashboardBody(
    fluidRow(
      box(width = 2, actionButton("count", "Count")),
      infoBoxOutput("ibox"),
      valueBoxOutput("vbox")
    )
  )
)

server <- function(input, output) {
  output$ibox <- renderInfoBox({
    infoBox(
      "Title",
      input$count,
      icon = icon("credit-card")
    )
  })
  output$vbox <- renderValueBox({
    valueBox(
      "Title",
      input$count,
      icon = icon("credit-card")
    )
  })
}

shinyApp(ui, server)
}
}
\seealso{
\code{\link{valueBoxOutput}} for the corresponding UI-side function.
}

